/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.concurrent;

import java.util.concurrent.atomic.AtomicReference;

public class AtomicWrappingCounterLong {
    private final AtomicReference<Long> counter;
    private final long initialValue;
    private final long maxValue;

    public AtomicWrappingCounterLong(long initialValue) {
        this(initialValue, Long.MAX_VALUE);
    }

    public AtomicWrappingCounterLong(long initialValue, long maxValue) {
        this.initialValue = initialValue;
        this.maxValue = maxValue;
        this.counter = new AtomicReference<Long>(initialValue);
    }

    public long get() {
        return this.counter.get();
    }

    public long getAndIncrement() {
        return this.counter.getAndUpdate(current -> current == this.maxValue ? this.initialValue : current + 1L);
    }

    public void reset() {
        this.counter.set(this.initialValue);
    }
}

