/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.concurrent;

import com.swiftmq.tools.concurrent.AsyncCompletionCallback;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public abstract class CallbackJoin {
    protected volatile boolean finalSuccess = true;
    protected volatile Object finalResult = null;
    protected volatile Exception finalException = null;
    AtomicInteger numberCallbacks = new AtomicInteger();
    volatile boolean blocked = true;
    private final AtomicReference<AsyncCompletionCallback> nextRef = new AtomicReference();

    protected CallbackJoin(AsyncCompletionCallback next) {
        this.nextRef.set(next);
    }

    protected CallbackJoin() {
    }

    private AsyncCompletionCallback getNext() {
        if (this.blocked || this.nextRef.get() == null) {
            return null;
        }
        return this.nextRef.getAndSet(null);
    }

    private void checkNext() {
        AsyncCompletionCallback theNext = this.getNext();
        if (theNext != null) {
            theNext.setException(this.finalException);
            theNext.setResult(this.finalResult);
            theNext.notifyCallbackStack(this.finalSuccess);
        }
    }

    public void incNumberCallbacks() {
        this.numberCallbacks.incrementAndGet();
    }

    public void setNumberCallbacks(int numberCallbacks) {
        this.numberCallbacks.set(numberCallbacks);
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
        if (this.numberCallbacks.get() == 0) {
            this.checkNext();
        }
    }

    public void done(AsyncCompletionCallback callback, boolean success) {
        int n = this.numberCallbacks.decrementAndGet();
        this.callbackDone(callback, success, n == 0);
        if (n == 0) {
            this.checkNext();
        }
    }

    protected abstract void callbackDone(AsyncCompletionCallback var1, boolean var2, boolean var3);
}

