/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.file;

import com.swiftmq.tools.file.NumberGenerationProvider;
import com.swiftmq.tools.file.RolloverSizeProvider;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class GenerationalFileWriter
extends Writer {
    static DecimalFormat FMTROTATE = new DecimalFormat("'-'000'.log'");
    final AtomicReference<String> directory = new AtomicReference();
    final AtomicReference<String> filename = new AtomicReference();
    final AtomicReference<File> file = new AtomicReference();
    final AtomicReference<FileWriter> writer = new AtomicReference();
    final AtomicLong length = new AtomicLong();
    final AtomicInteger generation = new AtomicInteger();
    final RolloverSizeProvider rolloverSizeProvider;
    final NumberGenerationProvider numberGenerationProvider;

    public GenerationalFileWriter(String directory, String filename, RolloverSizeProvider rolloverSizeProvider, NumberGenerationProvider numberGenerationProvider) throws IOException {
        this.directory.set(directory);
        this.filename.set(filename);
        this.rolloverSizeProvider = rolloverSizeProvider;
        this.numberGenerationProvider = numberGenerationProvider;
        this.newLogfile();
    }

    private void checkGenerations() throws IOException {
        File dir = new File(this.directory.get());
        if (!dir.exists()) {
            dir.mkdir();
            return;
        }
        Object[] names = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.startsWith(GenerationalFileWriter.this.filename.get()) && name.endsWith(".log");
            }
        });
        if (names != null) {
            Arrays.sort(names);
            for (int i = 0; i < names.length; ++i) {
                int logIdx = ((String)names[i]).indexOf(".log");
                if (logIdx - 3 < 0) continue;
                int g = Integer.parseInt(((String)names[i]).substring(logIdx - 3, logIdx));
                this.generation.set(Math.max(g, this.generation.get()));
            }
            int todDel = names.length - this.numberGenerationProvider.getNumberGenerations();
            if (this.generation.get() == 999) {
                this.generation.set(0);
                todDel = names.length;
            }
            if (todDel > 0) {
                for (int i = 0; i < todDel; ++i) {
                    new File(dir, (String)names[i]).delete();
                }
            }
        }
    }

    private void newLogfile() throws IOException {
        this.checkGenerations();
        this.file.set(new File(String.valueOf(this.directory) + File.separator + String.valueOf(this.filename) + FMTROTATE.format(this.generation.getAndIncrement())));
        if (this.file.get().exists()) {
            this.length.set(this.file.get().length());
        } else {
            this.length.set(0L);
        }
        this.writer.set(new FileWriter(this.file.get(), true));
    }

    private void checkRolling() throws IOException {
        long max = this.rolloverSizeProvider.getRollOverSize();
        if (max == -1L) {
            return;
        }
        if (this.length.get() > max) {
            this.writer.get().flush();
            this.writer.get().close();
            this.newLogfile();
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.writer.get() == null) {
            return;
        }
        this.writer.get().write(cbuf, off, len);
        this.writer.get().flush();
        this.length.addAndGet(len - off);
        this.checkRolling();
    }

    @Override
    public void write(String str) throws IOException {
        if (this.writer.get() == null) {
            return;
        }
        this.writer.get().write(str);
        this.writer.get().flush();
        this.length.addAndGet(str.length());
        this.checkRolling();
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (this.writer.get() == null) {
            return;
        }
        this.writer.get().write(str, off, len);
        this.writer.get().flush();
        this.length.addAndGet(len - off);
        this.checkRolling();
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        if (this.writer.get() == null) {
            return;
        }
        this.writer.get().write(cbuf);
        this.writer.get().flush();
        this.length.addAndGet(cbuf.length);
        this.checkRolling();
    }

    @Override
    public void flush() throws IOException {
        if (this.writer.get() == null) {
            return;
        }
        this.writer.get().flush();
        this.checkRolling();
    }

    @Override
    public void close() throws IOException {
        if (this.writer.get() == null) {
            return;
        }
        this.writer.get().flush();
        this.writer.get().close();
    }
}

