/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.file;

import com.swiftmq.tools.file.NumberGenerationProvider;
import com.swiftmq.tools.file.RolloverSizeProvider;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class RollingFileWriter
extends Writer {
    static SimpleDateFormat FMTROTATE = new SimpleDateFormat("'-'yyyyMMddHHmmss'.old'");
    final AtomicReference<String> filename = new AtomicReference();
    final AtomicReference<File> file = new AtomicReference();
    final AtomicReference<String> directory = new AtomicReference();
    final AtomicReference<FileWriter> writer = new AtomicReference();
    final AtomicLong length = new AtomicLong();
    final AtomicInteger generation = new AtomicInteger();
    final AtomicReference<RolloverSizeProvider> rolloverSizeProvider = new AtomicReference();
    final AtomicReference<NumberGenerationProvider> numberGenerationProvider = new AtomicReference();

    public RollingFileWriter(String filename, RolloverSizeProvider rolloverSizeProvider, NumberGenerationProvider numberGenerationProvider) throws IOException {
        this(filename, rolloverSizeProvider);
        this.numberGenerationProvider.set(numberGenerationProvider);
    }

    public RollingFileWriter(String filename, RolloverSizeProvider rolloverSizeProvider) throws IOException {
        this.filename.set(filename);
        this.rolloverSizeProvider.set(rolloverSizeProvider);
        this.file.set(new File(filename));
        this.directory.set(this.file.get().getParent());
        if (this.file.get().exists()) {
            this.length.set(this.file.get().length());
        }
        this.writer.set(new FileWriter(filename, true));
    }

    private void checkGenerations() throws IOException {
        int ngen = this.numberGenerationProvider.get().getNumberGenerations();
        if (ngen <= 0) {
            return;
        }
        File dir = new File(this.directory.get());
        if (!dir.exists()) {
            dir.mkdir();
            return;
        }
        final String fn = this.file.get().getName();
        String[] names = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.startsWith(fn) && name.endsWith(".old");
            }
        });
        if (names != null) {
            Arrays.sort(names, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.substring(o1.indexOf(".old") - 14).compareTo(o2.substring(o2.indexOf(".old") - 14));
                }
            });
            int todDel = names.length - ngen;
            if (todDel > 0) {
                for (int i = 0; i < todDel; ++i) {
                    new File(dir, names[i]).delete();
                }
            }
        }
    }

    private void checkRolling() throws IOException {
        long max = this.rolloverSizeProvider.get().getRollOverSize();
        if (max == -1L) {
            return;
        }
        if (this.length.get() > max) {
            this.writer.get().flush();
            this.writer.get().close();
            File f = new File(String.valueOf(this.filename) + "-" + this.generation.getAndIncrement() + FMTROTATE.format(new Date()));
            this.file.get().renameTo(f);
            this.file.set(new File(this.filename.get()));
            this.writer.set(new FileWriter(this.filename.get(), true));
            this.length.set(0L);
            if (this.numberGenerationProvider.get() != null) {
                this.checkGenerations();
            }
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.writer.get() == null) {
            return;
        }
        this.writer.get().write(cbuf, off, len);
        this.writer.get().flush();
        this.length.addAndGet(len - off);
        this.checkRolling();
    }

    @Override
    public void write(String str) throws IOException {
        if (this.writer.get() == null) {
            return;
        }
        this.writer.get().write(str);
        this.writer.get().flush();
        this.length.addAndGet(str.length());
        this.checkRolling();
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (this.writer.get() == null) {
            return;
        }
        this.writer.get().write(str, off, len);
        this.writer.get().flush();
        this.length.addAndGet(len - off);
        this.checkRolling();
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        if (this.writer.get() == null) {
            return;
        }
        this.writer.get().write(cbuf);
        this.writer.get().flush();
        this.length.addAndGet(cbuf.length);
        this.checkRolling();
    }

    @Override
    public void flush() throws IOException {
        if (this.writer.get() == null) {
            return;
        }
        this.writer.get().flush();
        this.checkRolling();
    }

    @Override
    public void close() throws IOException {
        if (this.writer.get() == null) {
            return;
        }
        this.writer.get().flush();
        this.writer.get().close();
    }
}

