/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.gc;

import com.swiftmq.tools.collection.RingBuffer;

public abstract class ObjectRecycler {
    static final int DEFAULT_SIZE = 128;
    RingBuffer freeList = null;
    int maxSize = -1;

    public ObjectRecycler(int maxSize) {
        this.maxSize = maxSize;
        this.freeList = new RingBuffer(128);
    }

    public ObjectRecycler() {
        this(-1);
    }

    protected abstract Object createRecyclable();

    public Object checkOut() {
        Object recyclable = null;
        recyclable = this.freeList.getSize() > 0 ? this.freeList.remove() : this.createRecyclable();
        return recyclable;
    }

    public void checkIn(Object recyclable) {
        if (this.maxSize == -1 || this.freeList.getSize() < this.maxSize) {
            this.freeList.add(recyclable);
        }
    }

    public int getSize() {
        return this.freeList.getSize();
    }

    public void clear() {
        this.freeList.clear();
    }
}

