/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.gc;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;

public class WeakPool<T> {
    private final ConcurrentLinkedQueue<WeakReference<T>> pool = new ConcurrentLinkedQueue();
    private final ReferenceQueue<T> refQueue = new ReferenceQueue();

    public T get(Supplier<T> creator) {
        WeakReference<T> ref;
        this.cleanUp();
        while ((ref = this.pool.poll()) != null) {
            Object object = ref.get();
            if (object == null) continue;
            return object;
        }
        return creator.get();
    }

    public void checkIn(T object) {
        this.pool.offer(new WeakReference<T>(object, this.refQueue));
    }

    private void cleanUp() {
        WeakReference ref;
        while ((ref = (WeakReference)this.refQueue.poll()) != null) {
            this.pool.remove(ref);
        }
    }
}

