/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.log;

import java.io.Serializable;
import java.util.Date;

public class LogValue
implements Serializable {
    public static final int INFORMATION = 0;
    public static final int WARNING = -1;
    public static final int ERROR = -2;
    String source = null;
    long time = 0L;
    int level = 0;
    String message = null;

    public LogValue(String source, int level, String message) {
        this.source = source;
        this.level = level;
        this.message = message;
        this.time = System.currentTimeMillis();
    }

    public String getSource() {
        return this.source;
    }

    public int getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public long getTime() {
        return this.time;
    }

    public String toString() {
        String sLevel = null;
        switch (this.level) {
            case 0: {
                sLevel = "INFORMATION";
                break;
            }
            case -1: {
                sLevel = "WARNING";
                break;
            }
            case -2: {
                sLevel = "ERROR";
            }
        }
        return "[" + String.valueOf(new Date(this.time)) + "] " + this.source + "/" + sLevel + "/" + this.message;
    }
}

