/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.prop;

import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class StructuredProperties {
    public static final String SECTION_QUALIFIER = ".names";
    Properties baseProperties = null;

    public StructuredProperties(Properties baseProperties) {
        this.baseProperties = baseProperties;
    }

    public Properties getBaseProperties() {
        return this.baseProperties;
    }

    public String[] getSections() {
        Vector<String> vec = new Vector<String>();
        Enumeration<?> e = this.baseProperties.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            if (!propName.endsWith(SECTION_QUALIFIER)) continue;
            vec.addElement(propName.substring(0, propName.indexOf(SECTION_QUALIFIER)));
        }
        String[] rArray = new String[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            rArray[i] = (String)vec.elementAt(i);
        }
        return rArray;
    }

    public boolean hasSection(String sectionPrefix) {
        return this.baseProperties.get(sectionPrefix + SECTION_QUALIFIER) != null;
    }

    public String[] getSectionElements(String sectionPrefix) {
        String propValue = (String)this.baseProperties.get(sectionPrefix + SECTION_QUALIFIER);
        if (propValue == null) {
            return null;
        }
        StringTokenizer t = new StringTokenizer(propValue, ",");
        String[] rArray = new String[t.countTokens()];
        int i = 0;
        while (t.hasMoreTokens()) {
            rArray[i++] = t.nextToken();
        }
        return rArray;
    }

    public String getValue(String sectionPrefix, String sectionElement, String propertyName) {
        return (String)this.baseProperties.get(sectionPrefix + "." + sectionElement + "." + propertyName);
    }
}

