/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.requestreply;

import com.swiftmq.tools.requestreply.GenericReply;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestVisitor;
import com.swiftmq.tools.util.DataByteArrayInputStream;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class GenericRequest
extends Request {
    Serializable payload = null;

    public GenericRequest(int dispatchId, boolean replyRequired, Serializable payload) {
        super(dispatchId, replyRequired);
        this.payload = payload;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        if (this.payload == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            DataByteArrayOutputStream dos = new DataByteArrayOutputStream(256);
            new ObjectOutputStream(dos).writeObject(this.payload);
            out.writeInt(dos.getCount());
            out.write(dos.getBuffer(), 0, dos.getCount());
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        byte set = in.readByte();
        if (set == 0) {
            this.payload = null;
        } else {
            try {
                byte[] b = new byte[in.readInt()];
                in.readFully(b);
                this.payload = (Serializable)new ObjectInputStream(new DataByteArrayInputStream(b)).readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    protected Reply createReplyInstance() {
        return new GenericReply();
    }

    public Serializable getPayload() {
        return this.payload;
    }

    public void setPayload(Serializable payload) {
        this.payload = payload;
    }

    @Override
    public void accept(RequestVisitor visitor) {
        visitor.visitGenericRequest(this);
    }

    @Override
    public String toString() {
        return "[GenericRequest " + super.toString() + " payload=" + String.valueOf(this.payload) + "]";
    }
}

