/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.requestreply;

import com.swiftmq.tools.concurrent.Semaphore;
import com.swiftmq.tools.dump.Dumpable;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.ReplyHandler;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public abstract class Request
implements Dumpable,
Serializable {
    public static final int NO_TIMEOUT = -1;
    public volatile Semaphore _sem = null;
    int dispatchId = -1;
    int requestNumber = 0;
    int correlationId = 0;
    volatile transient Reply reply = null;
    long timeout = -1L;
    boolean replyRequired = true;
    volatile transient ReplyHandler replyHandler;
    volatile transient RequestRetryValidator validator = null;
    volatile transient boolean doRetry = false;
    volatile transient boolean wasRetry = false;
    volatile transient boolean cancelledByValidator = false;
    transient int connectionId = -1;

    public Request(int dispatchId, boolean replyRequired) {
        this.dispatchId = dispatchId;
        this.replyRequired = replyRequired;
    }

    public Request(int dispatchId, boolean replyRequired, RequestRetryValidator validator) {
        this.dispatchId = dispatchId;
        this.replyRequired = replyRequired;
        this.validator = validator;
    }

    public boolean isDoRetry() {
        return this.doRetry;
    }

    public void setDoRetry(boolean doRetry) {
        this.doRetry = doRetry;
        if (doRetry) {
            this.wasRetry = true;
        }
    }

    public boolean isWasRetry() {
        return this.wasRetry;
    }

    public RequestRetryValidator getValidator() {
        return this.validator;
    }

    public void setValidator(RequestRetryValidator validator) {
        this.validator = validator;
    }

    public boolean isCancelledByValidator() {
        return this.cancelledByValidator;
    }

    public void setCancelledByValidator(boolean cancelledByValidator) {
        this.cancelledByValidator = cancelledByValidator;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(int connectionId) {
        this.connectionId = connectionId;
    }

    @Override
    public int getDumpId() {
        return 0;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        out.writeInt(this.dispatchId);
        out.writeInt(this.requestNumber);
        out.writeInt(this.correlationId);
        out.writeLong(this.timeout);
        out.writeBoolean(this.replyRequired);
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        this.dispatchId = in.readInt();
        this.requestNumber = in.readInt();
        this.correlationId = in.readInt();
        this.timeout = in.readLong();
        this.replyRequired = in.readBoolean();
    }

    public int getDispatchId() {
        return this.dispatchId;
    }

    public void setDispatchId(int dispatchId) {
        this.dispatchId = dispatchId;
    }

    public boolean isReplyRequired() {
        return this.replyRequired;
    }

    public void setReplyRequired(boolean replyRequired) {
        this.replyRequired = replyRequired;
    }

    long getTimeout() {
        return this.timeout;
    }

    void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    int getRequestNumber() {
        return this.requestNumber;
    }

    void setRequestNumber(int requestNumber) {
        this.requestNumber = requestNumber;
    }

    Reply getReply() {
        return this.reply;
    }

    void setReply(Reply reply) {
        this.reply = reply;
    }

    public int getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(int correlationId) {
        this.correlationId = correlationId;
    }

    void setReplyHandler(ReplyHandler replyHandler) {
        this.replyHandler = replyHandler;
    }

    protected abstract Reply createReplyInstance();

    public Reply createReply() {
        Reply reply = this.createReplyInstance();
        reply.setRequestNumber(this.requestNumber);
        reply.setReplyHandler(this.replyHandler);
        return reply;
    }

    public abstract void accept(RequestVisitor var1);

    public String toString() {
        return "[Request, dispatchId=" + this.dispatchId + " requestNumber=" + this.requestNumber + " correlationId=" + this.correlationId + " timeout=" + this.timeout + " replyRequired=" + this.replyRequired + " reply=" + String.valueOf(this.reply) + "]";
    }
}

