/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.requestreply;

import com.swiftmq.tools.collection.ConcurrentExpandableList;
import com.swiftmq.tools.concurrent.Semaphore;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestHandler;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.TimeoutException;
import com.swiftmq.tools.requestreply.TransportException;
import com.swiftmq.tools.requestreply.ValidationException;
import com.swiftmq.tools.timer.TimerEvent;
import com.swiftmq.tools.timer.TimerListener;
import com.swiftmq.tools.timer.TimerRegistry;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RequestRegistry
implements TimerListener {
    public static final long SWIFTMQ_REQUEST_TIMEOUT = Long.parseLong(System.getProperty("swiftmq.request.timeout", "60000"));
    public static final boolean DEBUG = Boolean.valueOf(System.getProperty("swiftmq.reconnect.debug", "false"));
    static final int TIMEOUT_CHECKINTERVAL = 10000;
    static boolean wrapPrivileged = false;
    ConcurrentExpandableList<Request> requestList = new ConcurrentExpandableList();
    RequestHandler requestHandler = null;
    final AtomicBoolean valid = new AtomicBoolean(true);
    final AtomicBoolean paused = new AtomicBoolean(false);
    final AtomicBoolean requestTimeoutEnabled = new AtomicBoolean(true);
    Semaphore retrySem = null;
    Set<Request> retrySet = ConcurrentHashMap.newKeySet();
    String debugString = null;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public RequestRegistry() {
    }

    public RequestRegistry(String debugString) {
        this.debugString = debugString;
    }

    public static void setWrapPrivileged(boolean wrapPrivileged) {
        RequestRegistry.wrapPrivileged = wrapPrivileged;
    }

    public void setRequestTimeoutEnabled(boolean requestTimeoutEnabled) {
        this.requestTimeoutEnabled.set(requestTimeoutEnabled);
        if (requestTimeoutEnabled) {
            TimerRegistry.Singleton().addTimerListener(10000L, (TimerListener)this);
        }
    }

    public void setPaused(boolean paused) {
        this.lock.writeLock().lock();
        try {
            this.paused.set(paused);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void setRequestHandler(RequestHandler requestHandler) {
        this.requestHandler = wrapPrivileged ? new PrivilegedRequestHandler(requestHandler) : requestHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reply request(Request req) {
        if (!req.isReplyRequired()) {
            this.requestHandler.performRequest(req);
            return null;
        }
        req._sem = new Semaphore(false);
        do {
            this.processRequest(req);
            req._sem.waitHere();
            if (req.getReply() == null && req.isDoRetry()) {
                RequestRetryValidator validator;
                if (DEBUG) {
                    System.out.println(this.debugString + ": Retry: " + String.valueOf(req));
                }
                if ((validator = req.getValidator()) != null) {
                    ValidationException validateException = null;
                    try {
                        validator.validate(req);
                    }
                    catch (ValidationException e) {
                        validateException = e;
                    }
                    if (req.isCancelledByValidator()) {
                        Reply reply = req.createReply();
                        if (validateException != null) {
                            reply.setOk(false);
                            reply.setException(validateException);
                        } else {
                            reply.setOk(true);
                        }
                        req.setReply(reply);
                        req.setDoRetry(false);
                        this.lock.writeLock().lock();
                        try {
                            this.retrySet.remove(req);
                            if (this.retrySet.size() == 0 && this.retrySem != null) {
                                this.retrySem.notifySingleWaiter();
                                this.retrySem = null;
                            }
                        }
                        finally {
                            this.lock.writeLock().unlock();
                        }
                        if (DEBUG) {
                            System.out.println(this.debugString + ": Cancelled by Validator: " + String.valueOf(req));
                        }
                    } else {
                        if (DEBUG) {
                            System.out.println(this.debugString + ": After validate: " + String.valueOf(req));
                        }
                        req._sem.reset();
                    }
                } else {
                    if (DEBUG) {
                        System.out.println(this.debugString + ": No validator: " + String.valueOf(req));
                    }
                    req._sem.reset();
                }
            }
            if (req.getReply() != null || !req.isDoRetry() || !DEBUG) continue;
            System.out.println(this.debugString + ": No Reply && isDoRetry: " + String.valueOf(req));
        } while (req.getReply() == null && req.isDoRetry());
        return req.getReply();
    }

    private void processRequest(Request req) {
        this.lock.writeLock().lock();
        try {
            if (!this.valid.get()) {
                throw new RuntimeException("Invalid request (connection might be closed already)");
            }
            req.setReply(null);
            req.setDoRetry(false);
            if (this.requestTimeoutEnabled.get()) {
                req.setTimeout(System.currentTimeMillis() + SWIFTMQ_REQUEST_TIMEOUT);
            }
            req.setRequestNumber(this.requestList.add(req));
            if (!this.paused.get()) {
                this.requestHandler.performRequest(req);
            } else if (DEBUG) {
                System.out.println(this.debugString + ": Paused, request NOT sent: " + String.valueOf(req));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Semaphore setReplySynchronized(Reply reply) {
        this.lock.writeLock().lock();
        try {
            Semaphore sem = null;
            int reqNumber = reply.getRequestNumber();
            if (reqNumber < this.requestList.size()) {
                Request req = this.requestList.get(reqNumber);
                if (req != null) {
                    req.setReply(reply);
                    this.requestList.remove(reqNumber);
                    sem = req._sem;
                    if (req.isWasRetry()) {
                        if (DEBUG) {
                            System.out.println(this.debugString + ": Reply from Retry: " + String.valueOf(reply));
                        }
                        this.retrySet.remove(req);
                        if (this.retrySet.size() == 0) {
                            this.retrySem.notifySingleWaiter();
                            this.retrySem = null;
                        }
                    }
                }
            } else {
                System.out.println(this.debugString + ": reqNumber >= requestList.size(), " + reqNumber + ":" + this.requestList.size());
            }
            Semaphore semaphore = sem;
            return semaphore;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void setReply(Reply reply) {
        Semaphore sem = this.setReplySynchronized(reply);
        if (sem != null) {
            sem.notifySingleWaiter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllRequests(TransportException exception, boolean valid) {
        this.lock.writeLock().lock();
        try {
            for (int i = 0; i < this.requestList.size(); ++i) {
                Request req = this.requestList.get(i);
                if (req == null) continue;
                Reply reply = req.createReply();
                reply.setOk(false);
                reply.setException(exception);
                req.setReply(reply);
                req._sem.notifySingleWaiter();
            }
            this.requestList.clear();
            this.retrySet.clear();
            if (this.retrySem != null) {
                this.retrySem.notifySingleWaiter();
                this.retrySem = null;
            }
            this.valid.set(valid);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void cancelRetryAllRequests() {
        this.lock.writeLock().lock();
        try {
            this.retrySet.clear();
            if (this.retrySem != null) {
                this.retrySem.notifySingleWaiter();
                this.retrySem = null;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retryAllRequests(Semaphore rSem) {
        this.lock.writeLock().lock();
        try {
            this.retrySem = rSem;
            this.retrySet.clear();
            for (int i = 0; i < this.requestList.size(); ++i) {
                Request req = this.requestList.get(i);
                if (req == null) continue;
                this.retrySet.add(req);
                req.setDoRetry(true);
                req._sem.notifySingleWaiter();
            }
            this.requestList.clear();
            if (this.retrySet.isEmpty()) {
                this.retrySem.notifySingleWaiter();
                this.retrySem = null;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void cancelAllRequests(TransportException exception) {
        this.cancelAllRequests(exception, true);
    }

    public void cancelRequest(Request request) {
        this.lock.writeLock().lock();
        try {
            int idx = this.requestList.indexOf(request);
            if (idx != -1) {
                this.requestList.remove(idx);
                request.setReply(null);
                request._sem.notifySingleWaiter();
                if (request.isDoRetry()) {
                    this.retrySet.remove(request);
                    if (this.retrySem != null) {
                        this.retrySem.notifySingleWaiter();
                        this.retrySem = null;
                    }
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performTimeAction(TimerEvent evt) {
        this.lock.writeLock().lock();
        try {
            long actTime = System.currentTimeMillis();
            for (int i = 0; i < this.requestList.size(); ++i) {
                Request req = this.requestList.get(i);
                if (req == null || req.getTimeout() == -1L || req.getTimeout() >= actTime) continue;
                this.requestList.remove(i);
                Reply reply = req.createReply();
                reply.setOk(false);
                reply.setException(new TimeoutException("Request time out (" + SWIFTMQ_REQUEST_TIMEOUT + ") ms!"));
                reply.setTimeout(true);
                req.setReply(reply);
                req._sem.notifySingleWaiter();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void close() {
        if (this.requestTimeoutEnabled.get()) {
            TimerRegistry.Singleton().removeTimerListener(10000L, (TimerListener)this);
        }
    }

    private static class PrivilegedRequestHandler
    implements RequestHandler {
        RequestHandler realHandler = null;

        public PrivilegedRequestHandler(RequestHandler realHandler) {
            this.realHandler = realHandler;
        }

        @Override
        public void performRequest(Request request) {
            AccessController.doPrivileged(new PrivilegedRequestAction(request){

                public Object run() {
                    realHandler.performRequest(this.myRequest);
                    return null;
                }
            });
        }
    }

    private static abstract class PrivilegedRequestAction
    implements PrivilegedAction {
        Request myRequest = null;

        public PrivilegedRequestAction(Request request) {
            this.myRequest = request;
        }
    }
}

