/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.timer;

import com.swiftmq.tools.timer.TimerEvent;
import com.swiftmq.tools.timer.TimerListener;
import java.util.Calendar;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class TimerRegistry {
    private final Timer timer = new Timer(true);
    private final Map<TimerListener, TimerTask> listeners = new ConcurrentHashMap<TimerListener, TimerTask>();

    private TimerRegistry() {
    }

    public static TimerRegistry Singleton() {
        return InstanceHolder.instance;
    }

    private long computeDelay(byte timePoint) {
        Calendar cal = Calendar.getInstance();
        switch (timePoint) {
            case 0: {
                cal.add(13, 1);
                cal.set(14, 0);
                break;
            }
            case 1: {
                cal.add(12, 1);
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
            case 2: {
                cal.add(11, 1);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
            case 3: {
                cal.add(5, 1);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
            case 4: {
                int firstDay = cal.getFirstDayOfWeek();
                int actDay = cal.get(7);
                cal.add(5, 7 - (actDay - firstDay));
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
            case 5: {
                cal.add(2, 1);
                cal.set(5, 1);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
            }
        }
        return cal.getTime().getTime() - System.currentTimeMillis();
    }

    private long getTimepointMillis(byte timePoint) {
        long ms = 0L;
        switch (timePoint) {
            case 0: {
                ms = 1L;
                break;
            }
            case 1: {
                ms = 60L;
                break;
            }
            case 2: {
                ms = 3600L;
                break;
            }
            case 3: {
                ms = 86400L;
                break;
            }
            case 4: {
                ms = 604800L;
                break;
            }
            case 5: {
                ms = 2592000L;
            }
        }
        return ms * 1000L;
    }

    public void addTimerListener(long delay, TimerListener l) {
        DelayExecutor exec = new DelayExecutor(delay, l);
        this.listeners.put(l, exec);
        this.timer.schedule((TimerTask)exec, delay, delay);
    }

    public void addInstantTimerListener(long delay, TimerListener l) {
        DelayExecutor exec = new DelayExecutor(delay, l);
        this.timer.schedule((TimerTask)exec, delay);
    }

    public void addTimerListener(byte timePoint, TimerListener l) {
        TimepointExecutor exec = new TimepointExecutor(timePoint, l);
        this.listeners.put(l, exec);
        this.timer.scheduleAtFixedRate((TimerTask)exec, this.computeDelay(timePoint), this.getTimepointMillis(timePoint));
    }

    public void removeTimerListener(long delay, TimerListener l) {
        TimerTask exec = this.listeners.remove(l);
        if (exec != null) {
            exec.cancel();
        }
    }

    public void removeTimerListener(byte timePoint, TimerListener l) {
        TimerTask exec = this.listeners.remove(l);
        if (exec != null) {
            exec.cancel();
        }
    }

    public void removeAllTimers() {
        this.timer.cancel();
    }

    private static class InstanceHolder {
        public static TimerRegistry instance = new TimerRegistry();

        private InstanceHolder() {
        }
    }

    private class DelayExecutor
    extends TimerTask {
        TimerListener listener = null;
        long delay = 0L;

        public DelayExecutor(long delay, TimerListener listener) {
            this.delay = delay;
            this.listener = listener;
        }

        @Override
        public void run() {
            TimerListener l = this.listener;
            if (l != null) {
                l.performTimeAction(new TimerEvent((Object)l, this.delay));
            }
        }

        @Override
        public boolean cancel() {
            boolean b = super.cancel();
            this.listener = null;
            return b;
        }
    }

    private class TimepointExecutor
    extends TimerTask {
        TimerListener listener = null;
        byte timepoint = 0;

        public TimepointExecutor(byte timepoint, TimerListener listener) {
            this.timepoint = timepoint;
            this.listener = listener;
        }

        @Override
        public void run() {
            TimerListener l = this.listener;
            if (l != null) {
                l.performTimeAction(new TimerEvent((Object)l, this.timepoint));
            }
        }

        @Override
        public boolean cancel() {
            boolean b = super.cancel();
            this.listener = null;
            return b;
        }
    }
}

