/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.util;

import com.swiftmq.tools.util.DataByteArrayOutputStream;
import com.swiftmq.tools.util.LengthCaptureDataInput;
import com.swiftmq.tools.util.UTFUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class DataByteArrayInputStream
extends InputStream
implements LengthCaptureDataInput {
    byte[] buffer = null;
    int _offset = 0;
    int pos = 0;
    int max = 0;
    char[] strbuffer = new char[256];
    long captureLength = 0L;

    public DataByteArrayInputStream() {
    }

    public DataByteArrayInputStream(byte[] buffer) {
        this.buffer = buffer;
        this.pos = 0;
        this.max = buffer.length;
    }

    public DataByteArrayInputStream(DataByteArrayOutputStream dos) {
        byte[] b = dos.getBuffer();
        int cnt = dos.getCount();
        if (cnt > 0) {
            this.buffer = new byte[cnt];
            System.arraycopy(b, 0, this.buffer, 0, cnt);
        } else {
            this.buffer = new byte[0];
        }
        this.pos = 0;
        this.max = this.buffer.length;
    }

    @Override
    public void startCaptureLength() {
        this.captureLength = 0L;
    }

    @Override
    public long stopCaptureLength() {
        return this.captureLength;
    }

    public void setBuffer(byte[] b) {
        this.setBuffer(b, 0, b.length);
    }

    public void setBuffer(byte[] b, int off) {
        this.setBuffer(b, off, b.length - off);
    }

    public void setBuffer(byte[] b, int off, int len) {
        this.buffer = b;
        this.pos = off;
        this.max = off + len;
        this._offset = off;
        this.captureLength = 0L;
    }

    public int getMax() {
        return this.max;
    }

    @Override
    public int available() throws IOException {
        return this.max - this.pos;
    }

    @Override
    public int read() throws IOException {
        ++this.captureLength;
        return this.pos < this.max ? this.buffer[this.pos++] & 0xFF : -1;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (len + this.pos <= this.max) {
            System.arraycopy(this.buffer, this.pos, b, off, len);
            this.pos += len;
            this.captureLength += (long)len;
        } else {
            throw new EOFException();
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int skip = Math.min(n, this.max - this.pos);
        this.pos += skip;
        this.captureLength += (long)skip;
        return skip;
    }

    @Override
    public boolean readBoolean() throws IOException {
        if (this.pos < this.max) {
            ++this.captureLength;
            return this.buffer[this.pos++] != 0;
        }
        throw new EOFException();
    }

    @Override
    public byte readByte() throws IOException {
        if (this.pos < this.max) {
            ++this.captureLength;
            return this.buffer[this.pos++];
        }
        throw new EOFException();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        if (this.pos < this.max) {
            ++this.captureLength;
            return this.buffer[this.pos++] & 0xFF;
        }
        throw new EOFException();
    }

    @Override
    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + ch2);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + ch2;
    }

    @Override
    public char readChar() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + ch2);
    }

    @Override
    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    @Override
    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() throws IOException {
        return null;
    }

    @Override
    public String readUTF() throws IOException {
        int utfLength = this.readUnsignedShort();
        String s = UTFUtils.convertFromUTF8(this.buffer, this.pos, utfLength);
        this.pos += utfLength;
        this.captureLength += (long)utfLength;
        return s;
    }

    @Override
    public void reset() throws IOException {
        this.pos = 0;
        this.captureLength = 0L;
    }
}

