/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.util;

import com.swiftmq.tools.util.UTFUtils;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataByteArrayOutputStream
extends OutputStream
implements DataOutput {
    static final int BUFFER_SIZE = 8192;
    byte[] buffer = null;
    int count = 0;
    int extendSize = 8192;

    public DataByteArrayOutputStream() {
        this(8192, 8192);
    }

    public DataByteArrayOutputStream(int bufferSize) {
        this(bufferSize, bufferSize);
    }

    public DataByteArrayOutputStream(int bufferSize, int extendSize) {
        this.buffer = new byte[bufferSize];
        this.extendSize = extendSize;
    }

    public DataByteArrayOutputStream(byte[] buffer) {
        this.buffer = buffer;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getCount() {
        return this.count;
    }

    private void ensure(int size) {
        if (this.buffer.length < this.count + size) {
            byte[] b = new byte[this.buffer.length + Math.max(size - (this.buffer.length - this.count), this.extendSize)];
            System.arraycopy(this.buffer, 0, b, 0, this.count);
            this.buffer = b;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.ensure(1);
        this.buffer[this.count++] = (byte)b;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensure(len);
        System.arraycopy(b, off, this.buffer, this.count, len);
        this.count += len;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.ensure(1);
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.ensure(2);
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.ensure(2);
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.ensure(4);
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.ensure(8);
        this.write((int)(v >>> 56) & 0xFF);
        this.write((int)(v >>> 48) & 0xFF);
        this.write((int)(v >>> 40) & 0xFF);
        this.write((int)(v >>> 32) & 0xFF);
        this.write((int)(v >>> 24) & 0xFF);
        this.write((int)(v >>> 16) & 0xFF);
        this.write((int)(v >>> 8) & 0xFF);
        this.write((int)v & 0xFF);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        this.ensure(len);
        for (int i = 0; i < len; ++i) {
            this.write((byte)s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        this.ensure(len * 2);
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.write(v >>> 8 & 0xFF);
            this.write(v & 0xFF);
        }
    }

    @Override
    public void writeUTF(String str) throws IOException {
        int utfCount = UTFUtils.countUTFBytes(str);
        if (utfCount > 65535) {
            throw new UTFDataFormatException();
        }
        this.ensure(utfCount + 2);
        this.count = UTFUtils.writeShortToBuffer(utfCount, this.buffer, this.count);
        this.count = UTFUtils.writeUTFBytesToBuffer(str, this.buffer, this.count);
    }

    public void rewind() {
        this.count = 0;
    }
}

