/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.util;

import com.swiftmq.tools.util.DataByteBufferOutputStream;
import com.swiftmq.tools.util.LengthCaptureDataInput;
import com.swiftmq.tools.util.UTFUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class DataByteBufferInputStream
extends InputStream
implements LengthCaptureDataInput {
    ByteBuffer buffer = null;
    char[] strBuffer = new char[256];
    int startPos = 0;

    public DataByteBufferInputStream() {
    }

    public DataByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public DataByteBufferInputStream(DataByteBufferOutputStream dos) {
        this.buffer = dos.getBuffer();
        this.buffer.rewind();
    }

    @Override
    public void startCaptureLength() {
        this.startPos = this.buffer.position();
    }

    @Override
    public long stopCaptureLength() {
        return this.buffer.position() - this.startPos;
    }

    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public int getMax() {
        return this.buffer.limit();
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }

    @Override
    public int read() throws IOException {
        return this.buffer.hasRemaining() ? this.buffer.get() & 0xFF : -1;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (len > this.buffer.remaining()) {
            throw new EOFException();
        }
        this.buffer.get(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int skip = Math.min(n, this.buffer.remaining());
        this.buffer.position(this.buffer.position() + skip);
        return skip;
    }

    @Override
    public boolean readBoolean() throws IOException {
        if (this.buffer.hasRemaining()) {
            return this.buffer.get() != 0;
        }
        throw new EOFException();
    }

    @Override
    public byte readByte() throws IOException {
        if (this.buffer.hasRemaining()) {
            return this.buffer.get();
        }
        throw new EOFException();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        if (this.buffer.hasRemaining()) {
            return this.buffer.get() & 0xFF;
        }
        throw new EOFException();
    }

    @Override
    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + ch2);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + ch2;
    }

    @Override
    public char readChar() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + ch2);
    }

    @Override
    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    @Override
    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() throws IOException {
        return null;
    }

    @Override
    public String readUTF() throws IOException {
        return UTFUtils.decodeUTF(this.readUnsignedShort(), this);
    }

    @Override
    public void reset() throws IOException {
        this.buffer.rewind();
    }
}

