/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.util;

import com.swiftmq.tools.util.UTFUtils;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataStreamOutputStream
extends OutputStream
implements DataOutput {
    OutputStream outputStream = null;
    byte[] bytearr = new byte[8];

    public DataStreamOutputStream(OutputStream out) {
        this.outputStream = out;
    }

    public DataStreamOutputStream() {
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outputStream.write(b, 0, b.length);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.outputStream.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.outputStream.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.bytearr[0] = (byte)(v >>> 8 & 0xFF);
        this.bytearr[1] = (byte)(v & 0xFF);
        this.outputStream.write(this.bytearr, 0, 2);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.bytearr[0] = (byte)(v >>> 8 & 0xFF);
        this.bytearr[1] = (byte)(v & 0xFF);
        this.outputStream.write(this.bytearr, 0, 2);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.bytearr[0] = (byte)(v >>> 24 & 0xFF);
        this.bytearr[1] = (byte)(v >>> 16 & 0xFF);
        this.bytearr[2] = (byte)(v >>> 8 & 0xFF);
        this.bytearr[3] = (byte)(v & 0xFF);
        this.outputStream.write(this.bytearr, 0, 4);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.bytearr[0] = (byte)(v >>> 56 & 0xFFL);
        this.bytearr[1] = (byte)(v >>> 48 & 0xFFL);
        this.bytearr[2] = (byte)(v >>> 40 & 0xFFL);
        this.bytearr[3] = (byte)(v >>> 32 & 0xFFL);
        this.bytearr[4] = (byte)(v >>> 24 & 0xFFL);
        this.bytearr[5] = (byte)(v >>> 16 & 0xFFL);
        this.bytearr[6] = (byte)(v >>> 8 & 0xFFL);
        this.bytearr[7] = (byte)(v & 0xFFL);
        this.outputStream.write(this.bytearr, 0, 8);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.outputStream.write((byte)s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.writeChar(v);
        }
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        int utfCount = UTFUtils.countUTFBytes(str);
        if (utfCount > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] buffer = new byte[utfCount + 2];
        int offset = 0;
        offset = UTFUtils.writeShortToBuffer(utfCount, buffer, offset);
        offset = UTFUtils.writeUTFBytesToBuffer(str, buffer, offset);
        this.write(buffer, 0, offset);
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

