/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.util;

import com.swiftmq.tools.util.UTFUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

public class LazyUTF8String
implements Serializable {
    private AtomicReference<String> s = new AtomicReference();
    private AtomicReference<byte[]> buffer = new AtomicReference();
    private int utfLength;

    public LazyUTF8String(DataInput in) throws IOException {
        this.utfLength = in.readUnsignedShort();
        byte[] b = new byte[this.utfLength + 2];
        in.readFully(b, 2, this.utfLength);
        b[0] = (byte)(this.utfLength >>> 8 & 0xFF);
        b[1] = (byte)(this.utfLength & 0xFF);
        this.buffer.set(b);
    }

    public LazyUTF8String(String s) {
        try {
            if (s == null) {
                System.out.println("s==null");
                throw new NullPointerException();
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw e;
        }
        this.s.set(s);
    }

    private String bufferToString() throws Exception {
        return UTFUtils.convertFromUTF8(this.buffer.get(), 2, this.utfLength);
    }

    private byte[] stringToBuffer() throws Exception {
        this.utfLength = UTFUtils.countUTFBytes(this.s.get());
        if (this.utfLength > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] b = new byte[this.utfLength + 2];
        int count = 0;
        count = UTFUtils.writeShortToBuffer(this.utfLength, b, count);
        UTFUtils.writeUTFBytesToBuffer(this.s.get(), b, count);
        return b;
    }

    public String getString() {
        return this.getString(false);
    }

    public String getString(boolean clear) {
        try {
            String currentString = this.s.get();
            if (currentString == null) {
                currentString = this.bufferToString();
                if (this.s.compareAndSet(null, currentString)) {
                    if (clear) {
                        this.buffer.set(null);
                        this.utfLength = 0;
                    }
                } else {
                    currentString = this.s.get();
                }
            }
            return currentString;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getBuffer() {
        try {
            byte[] currentBuffer = this.buffer.get();
            if (currentBuffer == null && !this.buffer.compareAndSet(null, currentBuffer = this.stringToBuffer())) {
                currentBuffer = this.buffer.get();
            }
            return currentBuffer;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void writeContent(DataOutput out) throws IOException {
        out.write(this.getBuffer());
    }

    public String toString() {
        return "[LazyUTF8String, s=" + this.s.get() + ", buffer=" + Arrays.toString(this.buffer.get()) + "]";
    }
}

