/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.util;

import java.io.IOException;
import java.io.InputStream;

public class MultiByteArrayInputStream
extends InputStream {
    byte[][] buffers;
    int pos;
    int totalSize;
    byte[] currentBuffer;
    int currentBufferIndex;
    int currentBufferPosition;

    public MultiByteArrayInputStream(byte[][] buffers, int totalSize) {
        this.buffers = buffers;
        this.pos = 0;
        this.totalSize = totalSize;
        this.currentBuffer = buffers[0];
        this.currentBufferIndex = 0;
        this.currentBufferPosition = 0;
    }

    @Override
    public int read() {
        ++this.pos;
        if (this.currentBufferPosition < this.currentBuffer.length) {
            return this.currentBuffer[this.currentBufferPosition++] & 0xFF;
        }
        if (this.currentBufferIndex < this.buffers.length - 1) {
            this.currentBuffer = this.buffers[++this.currentBufferIndex];
            this.currentBufferPosition = 0;
            return this.currentBuffer[this.currentBufferPosition++] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int copyFromThisBuffer;
        if (this.pos >= this.totalSize) {
            return -1;
        }
        if (this.pos + len > this.totalSize) {
            len = this.totalSize - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        for (int toCopy = len; toCopy > 0; toCopy -= copyFromThisBuffer) {
            if (this.currentBufferPosition == this.currentBuffer.length) {
                this.currentBuffer = this.buffers[++this.currentBufferIndex];
                this.currentBufferPosition = 0;
            }
            copyFromThisBuffer = Math.min(toCopy, this.currentBuffer.length - this.currentBufferPosition);
            System.arraycopy(this.currentBuffer, this.currentBufferPosition, b, off, copyFromThisBuffer);
            this.currentBufferPosition += copyFromThisBuffer;
            off += copyFromThisBuffer;
        }
        this.pos += len;
        return len;
    }

    @Override
    public long skip(long n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int available() {
        return this.totalSize - this.pos;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.pos = 0;
        this.currentBuffer = this.buffers[0];
        this.currentBufferIndex = 0;
        this.currentBufferPosition = 0;
    }

    @Override
    public void close() throws IOException {
        this.buffers = null;
        this.currentBuffer = null;
    }
}

