/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.util;

import java.io.DataInput;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class UTFUtils {
    public static String decodeUTF(int utfSize, DataInput in) throws IOException {
        byte[] buf = new byte[utfSize];
        char[] out = new char[utfSize];
        in.readFully(buf, 0, utfSize);
        return UTFUtils.convertUTF8WithBuf(buf, out, 0, utfSize);
    }

    public static String convertFromUTF8(byte[] buf, int offset, int utfSize) throws UTFDataFormatException {
        return UTFUtils.convertUTF8WithBuf(buf, new char[utfSize], offset, utfSize);
    }

    public static String convertUTF8WithBuf(byte[] buf, char[] out, int offset, int utfSize) throws UTFDataFormatException {
        int count = 0;
        int s = 0;
        while (count < utfSize) {
            byte b;
            if ((out[s] = (char)buf[offset + count++]) < '\u0080') {
                ++s;
                continue;
            }
            char a = out[s];
            if ((a & 0xE0) == 192) {
                if (count >= utfSize) {
                    throw new UTFDataFormatException();
                }
                if (((b = buf[offset + count++]) & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                out[s++] = (char)((a & 0x1F) << 6 | b & 0x3F);
                continue;
            }
            if ((a & 0xF0) == 224) {
                if (count + 1 >= utfSize) {
                    throw new UTFDataFormatException();
                }
                b = buf[offset + count++];
                byte c = buf[offset + count++];
                if ((b & 0xC0) != 128 || (c & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                out[s++] = (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
                continue;
            }
            throw new UTFDataFormatException();
        }
        return new String(out, 0, s);
    }

    public static int countUTFBytes(String str) {
        int utfCount = 0;
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char charValue = str.charAt(i);
            if (charValue > '\u0000' && charValue <= '\u007f') {
                ++utfCount;
                continue;
            }
            if (charValue <= '\u07ff') {
                utfCount += 2;
                continue;
            }
            utfCount += 3;
        }
        return utfCount;
    }

    public static int writeShortToBuffer(int val, byte[] buffer, int offset) throws IOException {
        buffer[offset++] = (byte)(val >> 8);
        buffer[offset++] = (byte)val;
        return offset;
    }

    public static int writeUTFBytesToBuffer(String str, byte[] buffer, int offset) throws IOException {
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char charValue = str.charAt(i);
            if (charValue > '\u0000' && charValue <= '\u007f') {
                buffer[offset++] = (byte)charValue;
                continue;
            }
            if (charValue <= '\u07ff') {
                buffer[offset++] = (byte)(0xC0 | 0x1F & charValue >> 6);
                buffer[offset++] = (byte)(0x80 | 0x3F & charValue);
                continue;
            }
            buffer[offset++] = (byte)(0xE0 | 0xF & charValue >> 12);
            buffer[offset++] = (byte)(0x80 | 0x3F & charValue >> 6);
            buffer[offset++] = (byte)(0x80 | 0x3F & charValue);
        }
        return offset;
    }
}

