/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class UninterruptableWaiter {
    private final Lock lock;
    private final Condition condition;
    private boolean signalled = false;

    public UninterruptableWaiter(Lock lock) {
        this.lock = lock;
        this.condition = lock.newCondition();
    }

    public void doWait() {
        this.lock.lock();
        try {
            boolean wasInterrupted = Thread.interrupted();
            while (!this.signalled) {
                try {
                    this.condition.await();
                    if (!this.signalled) continue;
                    break;
                }
                catch (InterruptedException e) {
                    wasInterrupted = true;
                }
            }
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            this.signalled = false;
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWait(long timeout) {
        if (timeout == 0L) {
            this.doWait();
            return;
        }
        this.lock.lock();
        try {
            boolean wasInterrupted = Thread.interrupted();
            long nanos = TimeUnit.MILLISECONDS.toNanos(timeout);
            while (!this.signalled && nanos > 0L) {
                try {
                    nanos = this.condition.awaitNanos(nanos);
                }
                catch (InterruptedException e) {
                    wasInterrupted = true;
                }
            }
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            this.signalled = false;
            this.lock.unlock();
        }
    }

    public void signal() {
        this.lock.lock();
        try {
            this.signalled = true;
            this.condition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void signalAll() {
        this.lock.lock();
        try {
            this.signalled = true;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

