/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.versioning;

import com.swiftmq.tools.dump.Dumpable;
import com.swiftmq.tools.versioning.VersionObject;
import com.swiftmq.tools.versioning.VersionVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class VersionNotification
implements VersionObject,
Dumpable {
    String identifier = null;
    int[] acceptedVersions = null;

    public VersionNotification(String identifier, int[] acceptedVersions) {
        this.identifier = identifier;
        this.acceptedVersions = acceptedVersions;
    }

    public VersionNotification() {
    }

    @Override
    public int getDumpId() {
        return 0;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        if (this.identifier != null) {
            out.writeByte(1);
            out.writeUTF(this.identifier);
        } else {
            out.writeByte(0);
        }
        out.writeInt(this.acceptedVersions.length);
        for (int i = 0; i < this.acceptedVersions.length; ++i) {
            out.writeInt(this.acceptedVersions[i]);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        byte set = in.readByte();
        if (set == 1) {
            this.identifier = in.readUTF();
        }
        this.acceptedVersions = new int[in.readInt()];
        for (int i = 0; i < this.acceptedVersions.length; ++i) {
            this.acceptedVersions[i] = in.readInt();
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int[] getAcceptedVersions() {
        return this.acceptedVersions;
    }

    @Override
    public void accept(VersionVisitor visitor) {
        visitor.visit(this);
    }

    private String print(int[] a) {
        StringBuffer b = new StringBuffer("[");
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(a[i]);
        }
        b.append("]");
        return b.toString();
    }

    public String toString() {
        return "[VersionNotification, identifier=" + this.identifier + ", acceptedVersion=" + this.print(this.acceptedVersions) + "]";
    }
}

