/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider.internal;

import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderMethodResolver;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import com.tngtech.java.junit.dataprovider.common.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"}, justification="for backwards compatibility and easier migration to core")
public class DefaultDataProviderMethodResolver
extends com.tngtech.junit.dataprovider.resolver.DefaultDataProviderMethodResolver
implements DataProviderMethodResolver {
    @Override
    public List<FrameworkMethod> resolve(FrameworkMethod testMethod, UseDataProvider useDataProvider) {
        Preconditions.checkNotNull(testMethod, "testMethod must not be null");
        Preconditions.checkNotNull(useDataProvider, "useDataProvider must not be null");
        List<TestClass> dataProviderLocations = this.findDataProviderLocations(testMethod, useDataProvider.location());
        return this.findDataProviderMethods(dataProviderLocations, testMethod.getName(), useDataProvider.value());
    }

    protected List<TestClass> findDataProviderLocations(FrameworkMethod testMethod, Class<?>[] useDataProviderLocation) {
        if (useDataProviderLocation.length == 0) {
            return Collections.singletonList(new TestClass(testMethod.getMethod().getDeclaringClass()));
        }
        ArrayList<TestClass> result = new ArrayList<TestClass>();
        for (Class<?> location : useDataProviderLocation) {
            result.add(new TestClass(location));
        }
        return result;
    }

    protected List<FrameworkMethod> findDataProviderMethods(List<TestClass> locations, String testMethodName, String useDataProviderValue) {
        ArrayList<FrameworkMethod> result = new ArrayList<FrameworkMethod>();
        for (TestClass location : locations) {
            FrameworkMethod method = this.findDataProviderMethod(location, testMethodName, useDataProviderValue);
            if (method == null) continue;
            result.add(method);
        }
        return result;
    }

    protected FrameworkMethod findDataProviderMethod(TestClass location, String testMethodName, String useDataProviderValue) {
        List dataProviderMethods = location.getAnnotatedMethods(DataProvider.class);
        for (FrameworkMethod dataProviderMethod : dataProviderMethods) {
            if (!("<use_convention>".equals(useDataProviderValue) ? this.isMatchingNameConvention(testMethodName, dataProviderMethod.getName()) : dataProviderMethod.getName().equals(useDataProviderValue))) continue;
            return dataProviderMethod;
        }
        return null;
    }
}

