/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.load;

import com.twitter.elephantbird.mapreduce.io.BinaryWritable;
import com.twitter.elephantbird.pig.util.PigCounterHelper;
import com.twitter.elephantbird.util.HadoopCompat;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.pig.Expression;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.LoadPushDown;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.impl.util.UDFContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LzoBaseLoadFunc
extends LoadFunc
implements LoadMetadata,
LoadPushDown {
    private static final Logger LOG = LoggerFactory.getLogger(LzoBaseLoadFunc.class);
    protected RecordReader reader;
    private final PigCounterHelper counterHelper_ = new PigCounterHelper();
    protected Configuration jobConf;
    protected String contextSignature;
    protected static final String projectionKey = "LzoBaseLoadFunc_projectedFields";
    protected LoadPushDown.RequiredFieldList requiredFieldList = null;

    protected void incrCounter(String group, String counter, long incr) {
        this.counterHelper_.incrCounter(group, counter, incr);
    }

    protected void incrCounter(Enum<?> key, long incr) {
        this.counterHelper_.incrCounter(key, incr);
    }

    protected void incrCounter(Pair<String, String> groupCounterPair, long incr) {
        this.counterHelper_.incrCounter((String)groupCounterPair.first, (String)groupCounterPair.second, incr);
    }

    protected Properties getUDFProperties() {
        return UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.contextSignature});
    }

    public void setUDFContextSignature(String signature) {
        this.contextSignature = signature;
    }

    public void setLocation(String location, Job job) throws IOException {
        FileInputFormat.setInputPaths((Job)job, (String)location);
        this.jobConf = HadoopCompat.getConfiguration((JobContext)job);
        String projectedFields = this.getUDFProperties().getProperty(projectionKey);
        if (projectedFields != null) {
            this.requiredFieldList = (LoadPushDown.RequiredFieldList)ObjectSerializer.deserialize((String)projectedFields);
        }
    }

    protected <M> M getNextBinaryValue(TypeRef<M> typeRef) throws IOException {
        try {
            if (this.reader != null && this.reader.nextKeyValue()) {
                BinaryWritable writable = (BinaryWritable)this.reader.getCurrentValue();
                return (M)writable.get();
            }
        }
        catch (InterruptedException e) {
            LOG.error("InterruptedException encountered, bailing.", (Throwable)e);
            throw new IOException(e);
        }
        return null;
    }

    public List<LoadPushDown.OperatorSet> getFeatures() {
        return Arrays.asList(LoadPushDown.OperatorSet.PROJECTION);
    }

    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        return null;
    }

    protected LoadPushDown.RequiredFieldResponse pushProjectionHelper(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        try {
            this.getUDFProperties().setProperty(projectionKey, ObjectSerializer.serialize((Serializable)requiredFieldList));
        }
        catch (IOException e) {
            throw new FrontendException((Throwable)e);
        }
        return new LoadPushDown.RequiredFieldResponse(true);
    }

    public void prepareToRead(RecordReader reader, PigSplit split) {
        this.reader = reader;
    }

    public ResourceSchema getSchema(String filename, Job job) throws IOException {
        return null;
    }

    public String[] getPartitionKeys(String arg0, Job arg1) throws IOException {
        return null;
    }

    public ResourceStatistics getStatistics(String arg0, Job arg1) throws IOException {
        return null;
    }

    public void setPartitionFilter(Expression arg0) throws IOException {
    }
}

