/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.common.base.Preconditions;
import com.twitter.elephantbird.pig.util.AbstractWritableConverter;
import java.io.DataInput;
import java.io.IOException;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;

public class GenericWritableConverter
extends AbstractWritableConverter<Writable> {
    private final DataInputBuffer ibuf = new DataInputBuffer();

    @Override
    public ResourceSchema.ResourceFieldSchema getLoadSchema() throws IOException {
        ResourceSchema.ResourceFieldSchema schema = new ResourceSchema.ResourceFieldSchema();
        schema.setType((byte)50);
        return schema;
    }

    @Override
    public void checkStoreSchema(ResourceSchema.ResourceFieldSchema schema) throws IOException {
        Preconditions.checkNotNull((Object)schema);
        if (schema.getType() != 50) {
            throw new IOException("Expected Pig type '" + DataType.findTypeName((byte)50) + "' but found '" + DataType.findTypeName((byte)schema.getType()) + "'");
        }
    }

    @Override
    protected Writable toWritable(DataByteArray value) throws IOException {
        Preconditions.checkNotNull((Object)this.writable, (Object)"Writable is null");
        byte[] bytes = value.get();
        this.ibuf.reset(bytes, bytes.length);
        this.writable.readFields((DataInput)this.ibuf);
        return this.writable;
    }
}

