/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.checkbox;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.GeneratedVaadinCheckbox;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeListener;
import java.io.Serializable;

public class Checkbox
extends GeneratedVaadinCheckbox<Checkbox, Boolean>
implements HasSize {
    private final Label labelElement = this.appendLabelElement();
    private static final PropertyChangeListener NO_OP = (PropertyChangeListener & Serializable)event -> {};

    public Checkbox() {
        super(false, false, false, true);
        this.getElement().addPropertyChangeListener("indeterminate", "indeterminate-changed", NO_OP);
        this.getElement().addPropertyChangeListener("checked", "checked-changed", NO_OP);
        this.setIndeterminate(false);
    }

    public Checkbox(String labelText) {
        this();
        this.setLabel(labelText);
    }

    public Checkbox(boolean initialValue) {
        this();
        this.setValue(initialValue);
    }

    public Checkbox(String labelText, boolean initialValue) {
        this(labelText);
        this.setValue(initialValue);
    }

    public Checkbox(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<Checkbox, Boolean>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public String getLabel() {
        return this.getElement().getChildren().filter(child -> child.getTag().equals("label")).findFirst().get().getText();
    }

    private Label appendLabelElement() {
        Label label = new Label();
        label.getElement().setAttribute("slot", "label");
        this.getElement().appendChild(new Element[]{label.getElement()});
        return label;
    }

    public void setLabel(String label) {
        this.labelElement.setText(label);
    }

    public void setLabelAsHtml(String htmlContent) {
        this.labelElement.getElement().setProperty("innerHTML", htmlContent);
    }

    public void setAriaLabel(String ariaLabel) {
        this.getElement().setAttribute("aria-label", ariaLabel);
    }

    @Override
    public void setAutofocus(boolean autofocus) {
        super.setAutofocus(autofocus);
    }

    public boolean isAutofocus() {
        return this.isAutofocusBoolean();
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        super.setIndeterminate(indeterminate);
    }

    public boolean isIndeterminate() {
        return this.isIndeterminateBoolean();
    }
}

