/*
 * Decompiled with CFR 0.152.
 */
package com.cucumber.listener;

import com.relevantcodes.extentreports.DisplayOrder;
import com.relevantcodes.extentreports.ExtentReports;
import com.relevantcodes.extentreports.ExtentTest;
import com.relevantcodes.extentreports.LogStatus;
import com.relevantcodes.extentreports.NetworkMode;
import cucumber.runtime.CucumberException;
import cucumber.runtime.io.URLOutputStream;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import gherkin.formatter.model.Tag;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtentCucumberFormatter
implements Reporter,
Formatter {
    private static ExtentReports extent;
    private ExtentTest featureTest;
    private ExtentTest scenarioTest;
    private LinkedList<Step> testSteps = new LinkedList();
    private static File htmlReportDir;
    private static Map systemInfo;
    private boolean scenarioOutlineTest;
    private static final Map<String, String> MIME_TYPES_EXTENSIONS;

    public ExtentCucumberFormatter(File filePath) {
        if (!filePath.getPath().equals("")) {
            String reportPath = filePath.getPath();
            htmlReportDir = new File(reportPath);
            extent = new ExtentReports(reportPath);
        } else {
            String reportDir = "output/Run_" + System.currentTimeMillis();
            htmlReportDir = new File(reportDir);
            extent = new ExtentReports(reportDir + "/report.html");
        }
    }

    public ExtentCucumberFormatter() {
    }

    public static void initiateExtentCucumberFormatter(File filePath, Boolean replaceExisting, DisplayOrder displayOrder, NetworkMode networkMode, Locale locale) {
        htmlReportDir = filePath;
        extent = new ExtentReports(filePath.getAbsolutePath(), replaceExisting, displayOrder, networkMode, locale);
    }

    public static void initiateExtentCucumberFormatter(File filePath, Boolean replaceExisting, DisplayOrder displayOrder, NetworkMode networkMode) {
        ExtentCucumberFormatter.initiateExtentCucumberFormatter(filePath, replaceExisting, displayOrder, networkMode, null);
    }

    public static void initiateExtentCucumberFormatter(File filePath, Boolean replaceExisting, DisplayOrder displayOrder, Locale locale) {
        ExtentCucumberFormatter.initiateExtentCucumberFormatter(filePath, replaceExisting, displayOrder, null, locale);
    }

    public static void initiateExtentCucumberFormatter(File filePath, Boolean replaceExisting, DisplayOrder displayOrder) {
        ExtentCucumberFormatter.initiateExtentCucumberFormatter(filePath, replaceExisting, displayOrder, null, null);
    }

    public static void initiateExtentCucumberFormatter(File filePath, Boolean replaceExisting, NetworkMode networkMode, Locale locale) {
        ExtentCucumberFormatter.initiateExtentCucumberFormatter(filePath, replaceExisting, null, networkMode, locale);
    }

    public static void initiateExtentCucumberFormatter(File filePath, Boolean replaceExisting, NetworkMode networkMode) {
        ExtentCucumberFormatter.initiateExtentCucumberFormatter(filePath, replaceExisting, null, networkMode, null);
    }

    public static void initiateExtentCucumberFormatter(File filePath, NetworkMode networkMode) {
        ExtentCucumberFormatter.initiateExtentCucumberFormatter(filePath, null, null, networkMode, null);
    }

    public static void initiateExtentCucumberFormatter(File filePath, Boolean replaceExisting, Locale locale) {
        ExtentCucumberFormatter.initiateExtentCucumberFormatter(filePath, replaceExisting, null, null, locale);
    }

    public static void initiateExtentCucumberFormatter(File filePath, Boolean replaceExisting) {
        ExtentCucumberFormatter.initiateExtentCucumberFormatter(filePath, replaceExisting, null, null, null);
    }

    public static void initiateExtentCucumberFormatter(File filePath, Locale locale) {
        ExtentCucumberFormatter.initiateExtentCucumberFormatter(filePath, null, null, null, locale);
    }

    public static void initiateExtentCucumberFormatter(File filePath) {
        ExtentCucumberFormatter.initiateExtentCucumberFormatter(filePath, null, null, null, null);
    }

    public static void initiateExtentCucumberFormatter() {
        String reportFilePath = "output" + File.separator + "Run_" + System.currentTimeMillis() + File.separator + "report.html";
        ExtentCucumberFormatter.initiateExtentCucumberFormatter(new File(reportFilePath));
    }

    public static void loadConfig(File configFile) {
        extent.loadConfig(configFile);
    }

    public static void addSystemInfo(String param, String value) {
        if (systemInfo == null) {
            systemInfo = new HashMap();
        }
        systemInfo.put(param, value);
    }

    public static void addSystemInfo(Map<String, String> info) {
        if (systemInfo == null) {
            systemInfo = new HashMap();
        }
        systemInfo.putAll(info);
    }

    public void before(Match match, Result result) {
    }

    public void result(Result result) {
        if (!this.scenarioOutlineTest) {
            if ("passed".equals(result.getStatus())) {
                this.scenarioTest.log(LogStatus.PASS, this.testSteps.poll().getName(), "PASSED");
            } else if ("failed".equals(result.getStatus())) {
                this.scenarioTest.log(LogStatus.FAIL, this.testSteps.poll().getName(), result.getErrorMessage());
            } else if ("skipped".equals(result.getStatus())) {
                this.scenarioTest.log(LogStatus.SKIP, this.testSteps.poll().getName(), "SKIPPED");
            } else if ("undefined".equals(result.getStatus())) {
                this.scenarioTest.log(LogStatus.UNKNOWN, this.testSteps.poll().getName(), "UNDEFINED");
            }
        }
    }

    public void after(Match match, Result result) {
    }

    public void match(Match match) {
    }

    public void embedding(String s, byte[] bytes) {
        if (!this.scenarioOutlineTest) {
            String extension = MIME_TYPES_EXTENSIONS.get(s);
            String fileName = "screenshot-" + System.currentTimeMillis() + "." + extension;
            this.writeBytesAndClose(bytes, this.reportFileOutputStream(fileName));
            this.scenarioTest.log(LogStatus.INFO, this.scenarioTest.addScreenCapture(fileName));
        }
    }

    public void write(String s) {
        if (!this.scenarioOutlineTest) {
            this.scenarioTest.log(LogStatus.INFO, s);
        }
    }

    public void syntaxError(String s, String s1, List<String> list, String s2, Integer integer) {
    }

    public void uri(String s) {
    }

    public void feature(Feature feature) {
        this.featureTest = extent.startTest("Feature: " + feature.getName());
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        this.scenarioOutlineTest = true;
    }

    public void examples(Examples examples) {
    }

    public void startOfScenarioLifeCycle(Scenario scenario) {
        this.scenarioTest = extent.startTest("Scenario: " + scenario.getName());
        for (Tag tag : scenario.getTags()) {
            this.scenarioTest.assignCategory(new String[]{tag.getName()});
        }
        this.scenarioOutlineTest = false;
    }

    public void background(Background background) {
    }

    public void scenario(Scenario scenario) {
    }

    public void step(Step step) {
        if (!this.scenarioOutlineTest) {
            this.testSteps.add(step);
        }
    }

    public void endOfScenarioLifeCycle(Scenario scenario) {
        if (!this.scenarioOutlineTest) {
            extent.endTest(this.scenarioTest);
            this.featureTest.appendChild(this.scenarioTest);
        }
    }

    public void done() {
    }

    public void close() {
        extent.addSystemInfo(systemInfo);
        extent.close();
    }

    public void eof() {
        extent.endTest(this.featureTest);
        extent.flush();
    }

    private OutputStream reportFileOutputStream(String fileName) {
        try {
            return new URLOutputStream(new URL(htmlReportDir.toURI().toURL(), fileName));
        }
        catch (IOException var3) {
            throw new CucumberException((Throwable)var3);
        }
    }

    private void writeBytesAndClose(byte[] buf, OutputStream out) {
        try {
            out.write(buf);
        }
        catch (IOException var4) {
            throw new CucumberException("Unable to write to report file item: ", (Throwable)var4);
        }
    }

    static {
        MIME_TYPES_EXTENSIONS = new HashMap(){
            {
                this.put("image/bmp", "bmp");
                this.put("image/gif", "gif");
                this.put("image/jpeg", "jpg");
                this.put("image/png", "png");
                this.put("image/svg+xml", "svg");
                this.put("video/ogg", "ogg");
            }
        };
    }
}

