/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.api.ApiRegistry;
import com.webcohesion.enunciate.artifacts.Artifact;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.metadata.Ignore;
import com.webcohesion.enunciate.module.ApiFeatureProviderModule;
import com.webcohesion.enunciate.module.ApiRegistryProviderModule;
import com.webcohesion.enunciate.module.BasicProviderModule;
import com.webcohesion.enunciate.module.MediaTypeDefinitionModule;
import com.webcohesion.enunciate.module.TypeDetectingModule;
import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.JaxbApiRegistry;
import com.webcohesion.enunciate.modules.jaxb.JaxbContextClassListArtifact;
import com.webcohesion.enunciate.modules.jaxb.NamespacePropertiesArtifact;
import com.webcohesion.enunciate.modules.jaxb.model.Registry;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.reflections.adapters.MetadataAdapter;

public class JaxbModule
extends BasicProviderModule
implements TypeDetectingModule,
MediaTypeDefinitionModule,
ApiRegistryProviderModule,
ApiFeatureProviderModule {
    private ApiRegistryProviderModule.DataTypeDetectionStrategy defaultDataTypeDetectionStrategy;
    private EnunciateJaxbContext jaxbContext;
    static final String NAME = "jaxb";

    public String getName() {
        return NAME;
    }

    public EnunciateJaxbContext getJaxbContext() {
        return this.jaxbContext;
    }

    public ApiRegistryProviderModule.DataTypeDetectionStrategy getDataTypeDetectionStrategy() {
        String dataTypeDetection = this.config.getString("[@datatype-detection]", null);
        if (dataTypeDetection != null) {
            try {
                return ApiRegistryProviderModule.DataTypeDetectionStrategy.valueOf((String)dataTypeDetection);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.defaultDataTypeDetectionStrategy == null ? ApiRegistryProviderModule.DataTypeDetectionStrategy.local : this.defaultDataTypeDetectionStrategy;
    }

    public boolean isDisableExamples() {
        return this.config.getBoolean("[@disableExamples]", false);
    }

    public void setDefaultDataTypeDetectionStrategy(ApiRegistryProviderModule.DataTypeDetectionStrategy strategy) {
        this.defaultDataTypeDetectionStrategy = strategy;
    }

    public ApiRegistry getApiRegistry() {
        return new JaxbApiRegistry(this.jaxbContext);
    }

    public void addDataTypeDefinitions(TypeMirror type, Set<String> declaredMediaTypes, LinkedList<Element> contextStack) {
        boolean jaxbApplies = false;
        for (String mediaType : declaredMediaTypes) {
            if (!"*/*".equals(mediaType) && !"text/*".equals(mediaType) && !"application/*".equals(mediaType) && !"text/xml".equals(mediaType) && !"application/xml".equals(mediaType) && !mediaType.endsWith("+xml")) continue;
            jaxbApplies = true;
            break;
        }
        if (jaxbApplies) {
            this.jaxbContext.addReferencedTypeDefinitions(type, contextStack);
        } else {
            this.debug("Element %s is NOT to be added as a JAXB data type because %s doesn't seem to include XML.", new Object[]{type, declaredMediaTypes});
        }
    }

    public void call(EnunciateContext context) {
        this.jaxbContext = new EnunciateJaxbContext(context, this.isDisableExamples(), this.getExternalExamples());
        ApiRegistryProviderModule.DataTypeDetectionStrategy detectionStrategy = this.getDataTypeDetectionStrategy();
        switch (detectionStrategy) {
            case aggressive: {
                for (Element declaration : context.getApiElements()) {
                    this.addPotentialJaxbElement(declaration, new LinkedList<Element>());
                }
                break;
            }
            case local: {
                for (Element declaration : context.getLocalApiElements()) {
                    this.addPotentialJaxbElement(declaration, new LinkedList<Element>());
                }
            }
            default: {
                if (!context.hasExplicitIncludes()) break;
                for (Element declaration : context.getApiElements()) {
                    this.addPotentialJaxbElement(declaration, new LinkedList<Element>());
                }
            }
        }
        this.enunciate.addArtifact((Artifact)new JaxbContextClassListArtifact(this.jaxbContext));
        this.enunciate.addArtifact((Artifact)new NamespacePropertiesArtifact(this.jaxbContext));
    }

    public Map<String, String> getExternalExamples() {
        HashMap<String, String> examples = new HashMap<String, String>();
        List exampleElements = this.config.configurationsAt("examples.example");
        for (HierarchicalConfiguration exampleElement : exampleElements) {
            examples.put(exampleElement.getString("[@type]", ""), exampleElement.getString("[@example]", "..."));
        }
        return examples;
    }

    public void addPotentialJaxbElement(Element declaration, LinkedList<Element> contextStack) {
        if (declaration instanceof TypeElement) {
            XmlRegistry registryMetadata = declaration.getAnnotation(XmlRegistry.class);
            if (registryMetadata != null) {
                Registry registry = new Registry((TypeElement)declaration, this.jaxbContext);
                this.jaxbContext.add(registry);
            } else if (!this.jaxbContext.isKnownTypeDefinition((TypeElement)declaration) && this.isExplicitTypeDefinition(declaration)) {
                this.jaxbContext.add(this.jaxbContext.createTypeDefinition((TypeElement)declaration), contextStack);
            }
        }
    }

    protected boolean isExplicitTypeDefinition(Element declaration) {
        if (declaration.getKind() != ElementKind.CLASS && declaration.getKind() != ElementKind.ENUM) {
            this.debug("%s isn't a potential JAXB type because it's not a class or an enum.", new Object[]{declaration});
            return false;
        }
        PackageElement pckg = this.context.getProcessingEnvironment().getElementUtils().getPackageOf(declaration);
        if (pckg != null && pckg.getAnnotation(Ignore.class) != null) {
            this.debug("%s isn't a potential JAXB type because its package is annotated as to be ignored.", new Object[]{declaration});
            return false;
        }
        if (this.isThrowable(declaration)) {
            this.debug("%s isn't a potential JAXB type because it's an instance of java.lang.Throwable.", new Object[]{declaration});
            return false;
        }
        List<? extends AnnotationMirror> annotationMirrors = declaration.getAnnotationMirrors();
        boolean explicitXMLTypeOrElement = false;
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            Element annotationDeclaration = annotationMirror.getAnnotationType().asElement();
            if (annotationDeclaration != null) {
                String fqn;
                String string = fqn = annotationDeclaration instanceof TypeElement ? ((TypeElement)annotationDeclaration).getQualifiedName().toString() : "";
                if (XmlTransient.class.getName().equals(fqn) || fqn.startsWith("javax.xml.ws") || fqn.startsWith("javax.ws.rs") || fqn.startsWith("javax.jws")) {
                    this.debug("%s isn't a potential JAXB type because of annotation %s.", new Object[]{declaration, fqn});
                    return false;
                }
                boolean bl = explicitXMLTypeOrElement = XmlType.class.getName().equals(fqn) || XmlRootElement.class.getName().equals(fqn);
            }
            if (!explicitXMLTypeOrElement) continue;
            break;
        }
        return explicitXMLTypeOrElement;
    }

    protected boolean isThrowable(Element declaration) {
        return declaration.getKind() == ElementKind.CLASS && ((DecoratedTypeMirror)declaration.asType()).isInstanceOf(Throwable.class);
    }

    public boolean internal(Object type, MetadataAdapter metadata) {
        return false;
    }

    public boolean typeDetected(Object type, MetadataAdapter metadata) {
        List classAnnotations = metadata.getClassAnnotationNames(type);
        if (classAnnotations != null) {
            for (String classAnnotation : classAnnotations) {
                if (!XmlType.class.getName().equals(classAnnotation) && !XmlRootElement.class.getName().equals(classAnnotation)) continue;
                return true;
            }
        }
        return false;
    }
}

