/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb.api.impl;

import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.datatype.BaseType;
import com.webcohesion.enunciate.api.datatype.BaseTypeFormat;
import com.webcohesion.enunciate.api.datatype.DataType;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.datatype.Example;
import com.webcohesion.enunciate.modules.jaxb.api.impl.ComplexDataTypeImpl;
import com.webcohesion.enunciate.modules.jaxb.api.impl.ComplexTypeExampleImpl;
import com.webcohesion.enunciate.modules.jaxb.api.impl.DataTypeImpl;
import com.webcohesion.enunciate.modules.jaxb.api.impl.EnumDataTypeImpl;
import com.webcohesion.enunciate.modules.jaxb.model.ComplexTypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.ElementDeclaration;
import com.webcohesion.enunciate.modules.jaxb.model.EnumTypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.types.KnownXmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlClassType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.xml.namespace.QName;

public class DataTypeReferenceImpl
implements DataTypeReference {
    private final XmlType xmlType;
    private final String label;
    private final String slug;
    private final List<DataTypeReference.ContainerType> containers;
    private final DataType dataType;
    private final QName elementQName;
    private static final Map<QName, BaseTypeAndFormat> type2typeformat = new HashMap<QName, BaseTypeAndFormat>();

    public DataTypeReferenceImpl(XmlType xmlType, boolean list, ApiRegistrationContext registrationContext) {
        DataTypeImpl dataType = null;
        QName elementQName = null;
        if (xmlType instanceof XmlClassType) {
            TypeDefinition typeDef = ((XmlClassType)xmlType).getTypeDefinition();
            if (typeDef instanceof ComplexTypeDefinition) {
                dataType = new ComplexDataTypeImpl((ComplexTypeDefinition)typeDef, registrationContext);
            } else if (typeDef instanceof EnumTypeDefinition) {
                dataType = new EnumDataTypeImpl((EnumTypeDefinition)typeDef, registrationContext);
            }
            ElementDeclaration elementDecl = typeDef.getContext().findElementDeclaration((Element)((Object)typeDef));
            if (elementDecl != null) {
                elementQName = elementDecl.getQname();
            }
        }
        this.xmlType = xmlType;
        this.label = dataType == null ? xmlType.getName() : dataType.getLabel();
        this.slug = dataType == null ? null : dataType.getSlug();
        this.containers = list ? Arrays.asList(DataTypeReference.ContainerType.list) : null;
        this.dataType = dataType;
        this.elementQName = elementQName;
    }

    public XmlType getXmlType() {
        return this.xmlType;
    }

    public BaseTypeFormat getBaseTypeFormat() {
        QName qname = this.getXmlType().getQname();
        BaseTypeAndFormat tf = type2typeformat.get(qname);
        return tf == null ? null : tf.format;
    }

    public BaseType getBaseType() {
        QName qname = this.getXmlType().getQname();
        BaseTypeAndFormat tf = type2typeformat.get(qname);
        if (tf != null) {
            return tf.type;
        }
        return this.xmlType.isSimple() ? BaseType.string : BaseType.object;
    }

    public String getLabel() {
        return this.label;
    }

    public String getSlug() {
        return this.slug;
    }

    public List<DataTypeReference.ContainerType> getContainers() {
        return this.containers;
    }

    public DataType getValue() {
        return this.dataType;
    }

    public QName getElementQName() {
        return this.elementQName;
    }

    public Example getExample() {
        ComplexTypeExampleImpl example = null;
        if (this.dataType instanceof ComplexDataTypeImpl) {
            ComplexTypeDefinition typeDefinition = ((ComplexDataTypeImpl)this.dataType).typeDefinition;
            example = typeDefinition == null || typeDefinition.getContext().isDisableExamples() ? null : new ComplexTypeExampleImpl(typeDefinition, this.containers);
        }
        return example;
    }

    static BaseTypeAndFormat typeFormat(BaseType type, BaseTypeFormat format) {
        return new BaseTypeAndFormat(type, format);
    }

    static {
        type2typeformat.put(KnownXmlType.BOOLEAN.getQname(), DataTypeReferenceImpl.typeFormat(BaseType.bool, null));
        type2typeformat.put(KnownXmlType.BYTE.getQname(), DataTypeReferenceImpl.typeFormat(BaseType.number, BaseTypeFormat.INT32));
        type2typeformat.put(KnownXmlType.DECIMAL.getQname(), DataTypeReferenceImpl.typeFormat(BaseType.number, BaseTypeFormat.INT64));
        type2typeformat.put(KnownXmlType.DOUBLE.getQname(), DataTypeReferenceImpl.typeFormat(BaseType.number, BaseTypeFormat.DOUBLE));
        type2typeformat.put(KnownXmlType.FLOAT.getQname(), DataTypeReferenceImpl.typeFormat(BaseType.number, BaseTypeFormat.FLOAT));
        type2typeformat.put(KnownXmlType.INT.getQname(), DataTypeReferenceImpl.typeFormat(BaseType.number, BaseTypeFormat.INT32));
        type2typeformat.put(KnownXmlType.INTEGER.getQname(), DataTypeReferenceImpl.typeFormat(BaseType.number, BaseTypeFormat.INT32));
        type2typeformat.put(KnownXmlType.LONG.getQname(), DataTypeReferenceImpl.typeFormat(BaseType.number, BaseTypeFormat.INT64));
        type2typeformat.put(KnownXmlType.NEGATIVE_INTEGER.getQname(), DataTypeReferenceImpl.typeFormat(BaseType.number, BaseTypeFormat.INT32));
        type2typeformat.put(KnownXmlType.NONNEGATIVE_INTEGER.getQname(), DataTypeReferenceImpl.typeFormat(BaseType.number, BaseTypeFormat.INT32));
        type2typeformat.put(KnownXmlType.NONPOSITIVE_INTEGER.getQname(), DataTypeReferenceImpl.typeFormat(BaseType.number, BaseTypeFormat.INT32));
        type2typeformat.put(KnownXmlType.POSITIVE_INTEGER.getQname(), DataTypeReferenceImpl.typeFormat(BaseType.number, BaseTypeFormat.INT32));
        type2typeformat.put(KnownXmlType.SHORT.getQname(), DataTypeReferenceImpl.typeFormat(BaseType.number, BaseTypeFormat.INT32));
        type2typeformat.put(KnownXmlType.UNSIGNED_BYTE.getQname(), DataTypeReferenceImpl.typeFormat(BaseType.number, BaseTypeFormat.INT32));
        type2typeformat.put(KnownXmlType.UNSIGNED_INT.getQname(), DataTypeReferenceImpl.typeFormat(BaseType.number, BaseTypeFormat.INT32));
        type2typeformat.put(KnownXmlType.UNSIGNED_LONG.getQname(), DataTypeReferenceImpl.typeFormat(BaseType.number, BaseTypeFormat.INT64));
        type2typeformat.put(KnownXmlType.UNSIGNED_SHORT.getQname(), DataTypeReferenceImpl.typeFormat(BaseType.number, BaseTypeFormat.INT32));
    }

    static class BaseTypeAndFormat {
        final BaseType type;
        final BaseTypeFormat format;

        BaseTypeAndFormat(BaseType type, BaseTypeFormat format) {
            this.type = type;
            this.format = format;
        }
    }
}

