/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation;

import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.datastores.aggregation.QueryValidator;
import com.yahoo.elide.datastores.aggregation.dynamic.NamespacePackage;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.metadata.models.Dimension;
import com.yahoo.elide.datastores.aggregation.metadata.models.Metric;
import com.yahoo.elide.datastores.aggregation.metadata.models.Namespace;
import com.yahoo.elide.datastores.aggregation.metadata.models.Table;
import com.yahoo.elide.datastores.aggregation.metadata.models.TableSource;
import com.yahoo.elide.datastores.aggregation.metadata.models.TimeDimension;
import com.yahoo.elide.datastores.aggregation.query.DimensionProjection;
import com.yahoo.elide.datastores.aggregation.query.MetricProjection;
import com.yahoo.elide.datastores.aggregation.query.Query;
import com.yahoo.elide.datastores.aggregation.query.QueryResult;
import com.yahoo.elide.datastores.aggregation.query.TimeDimensionProjection;
import java.util.List;
import java.util.Map;

public abstract class QueryEngine {
    protected MetaDataStore metaDataStore;
    protected EntityDictionary metadataDictionary;

    protected QueryEngine() {
    }

    public QueryEngine(MetaDataStore metaDataStore) {
        this.metaDataStore = metaDataStore;
        this.metadataDictionary = metaDataStore.getMetadataDictionary();
        this.populateMetaData(metaDataStore);
    }

    protected abstract Namespace constructNamespace(NamespacePackage var1);

    protected abstract Table constructTable(Namespace var1, Type<?> var2, EntityDictionary var3);

    public abstract DimensionProjection constructDimensionProjection(Dimension var1, String var2, Map<String, Argument> var3);

    public abstract TimeDimensionProjection constructTimeDimensionProjection(TimeDimension var1, String var2, Map<String, Argument> var3);

    public abstract MetricProjection constructMetricProjection(Metric var1, String var2, Map<String, Argument> var3);

    protected void populateMetaData(MetaDataStore metaDataStore) {
        metaDataStore.getNamespacesToBind().stream().map(this::constructNamespace).forEach(metaDataStore::addNamespace);
        metaDataStore.getModelsToBind().forEach(model -> {
            if (!this.metadataDictionary.isJPAEntity(model) && !this.metadataDictionary.getRelationships(model).isEmpty()) {
                throw new BadRequestException("Non-JPA entities " + model.getSimpleName() + " is not allowed to have relationship.");
            }
        });
        metaDataStore.getModelsToBind().stream().map(model -> this.constructTable(metaDataStore.getNamespace((Type<?>)model), (Type<?>)model, this.metadataDictionary)).forEach(metaDataStore::addTable);
        metaDataStore.getTables().forEach(table -> {
            table.getArgumentDefinitions().forEach(argument -> argument.setTableSource(TableSource.fromDefinition(argument.getTableSourceDefinition(), table.getVersion(), metaDataStore)));
            table.getColumns().forEach(column -> {
                column.setTableSource(TableSource.fromDefinition(column.getTableSourceDefinition(), table.getVersion(), metaDataStore));
                column.getArgumentDefinitions().forEach(argument -> argument.setTableSource(TableSource.fromDefinition(argument.getTableSourceDefinition(), table.getVersion(), metaDataStore)));
            });
        });
        this.verifyMetaData(metaDataStore);
    }

    protected abstract void verifyMetaData(MetaDataStore var1);

    public abstract Transaction beginTransaction();

    public abstract QueryResult executeQuery(Query var1, Transaction var2);

    public abstract String getTableVersion(Table var1, Transaction var2);

    public abstract List<String> explain(Query var1);

    public abstract QueryValidator getValidator();

    public MetaDataStore getMetaDataStore() {
        return this.metaDataStore;
    }

    public static interface Transaction
    extends AutoCloseable {
        @Override
        public void close();

        public void cancel();
    }
}

