/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.metadata;

import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.datastore.inmemory.HashMapDataStore;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.exceptions.InvalidOperationException;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.Relationship;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class MetaDataStoreTransaction
implements DataStoreTransaction {
    private static final Function<String, HashMapDataStore> REQUEST_ERROR = key -> {
        throw new BadRequestException("API version " + key + " not found");
    };
    private final Map<String, HashMapDataStore> hashMapDataStores;

    public MetaDataStoreTransaction(Map<String, HashMapDataStore> hashMapDataStores) {
        this.hashMapDataStores = hashMapDataStores;
    }

    public void flush(RequestScope requestScope) {
    }

    public void save(Object object, RequestScope requestScope) {
        throw new InvalidOperationException("save not supported for metadatastore");
    }

    public void delete(Object object, RequestScope requestScope) {
        throw new InvalidOperationException("delete not supported for metadatastore");
    }

    public void commit(RequestScope scope) {
    }

    public void createObject(Object entity, RequestScope scope) {
    }

    public Object getRelation(DataStoreTransaction relationTx, Object entity, Relationship relationship, RequestScope scope) {
        return this.hashMapDataStores.computeIfAbsent(scope.getApiVersion(), REQUEST_ERROR).getDictionary().getValue(entity, relationship.getName(), scope);
    }

    public Iterable<Object> loadObjects(EntityProjection projection, RequestScope scope) {
        return this.hashMapDataStores.computeIfAbsent(scope.getApiVersion(), REQUEST_ERROR).beginTransaction().loadObjects(projection, scope);
    }

    public Object loadObject(EntityProjection projection, Serializable id, RequestScope scope) {
        return this.hashMapDataStores.computeIfAbsent(scope.getApiVersion(), REQUEST_ERROR).beginTransaction().loadObject(projection, id, scope);
    }

    public void close() throws IOException {
    }

    public <T> DataStoreTransaction.FeatureSupport supportsFiltering(RequestScope scope, Optional<T> parent, EntityProjection projection) {
        return DataStoreTransaction.FeatureSupport.NONE;
    }

    public <T> boolean supportsSorting(RequestScope scope, Optional<T> parent, EntityProjection projection) {
        return false;
    }

    public <T> boolean supportsPagination(RequestScope scope, Optional<T> parent, EntityProjection projection) {
        return false;
    }

    public void cancel(RequestScope scope) {
    }
}

