/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.metadata.enums;

import com.google.common.collect.ImmutableMap;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import com.yahoo.elide.datastores.aggregation.timegrains.Time;
import java.math.BigDecimal;
import java.util.Map;
import java.util.regex.Pattern;

public enum ValueType {
    TIME("^[-0-9:TZ]+$"),
    INTEGER("^[+-]?\\d+$"),
    DECIMAL("^[+-]?((\\d+(\\.\\d+)?)|(\\.\\d+))$"),
    MONEY("^[+-]?((\\d+(\\.\\d+)?)|(\\.\\d+))$"),
    TEXT("^[a-zA-Z0-9_]+$"),
    COORDINATE("^(-?\\d+(\\.\\d+)?)|(-?\\d+(\\.\\d+)?),\\s*(-?\\d+(\\.\\d+)?)$"),
    BOOLEAN("^(?i)true|false(?-i)|0|1$"),
    ID("^[a-zA-Z0-9_]+$"),
    UNKNOWN("^$");

    private Pattern pattern;
    private static final Map<Type<?>, ValueType> SCALAR_TYPES;

    private ValueType(String regexRestriction) {
        this.pattern = Pattern.compile(regexRestriction);
    }

    public boolean matches(String input) {
        if (this.equals((Object)UNKNOWN)) {
            return false;
        }
        try {
            CoerceUtil.coerce((Object)input, ValueType.getType(this));
        }
        catch (InvalidValueException e) {
            return false;
        }
        return this.pattern.matcher(input).matches();
    }

    public static ValueType getScalarType(Type<?> fieldClass) {
        return SCALAR_TYPES.get(fieldClass);
    }

    public static Type<?> getType(ValueType valueType) {
        switch (valueType) {
            case TIME: {
                return Time.TIME_TYPE;
            }
            case TEXT: {
                return ClassType.STRING_TYPE;
            }
            case INTEGER: {
                return ClassType.LONG_TYPE;
            }
            case MONEY: {
                return ClassType.BIGDECIMAL_TYPE;
            }
            case DECIMAL: {
                return ClassType.BIGDECIMAL_TYPE;
            }
            case COORDINATE: {
                return ClassType.STRING_TYPE;
            }
            case BOOLEAN: {
                return ClassType.BOOLEAN_TYPE;
            }
        }
        return ClassType.STRING_TYPE;
    }

    static {
        SCALAR_TYPES = ImmutableMap.builder().put((Object)ClassType.of(Short.TYPE), (Object)INTEGER).put((Object)ClassType.of(Short.class), (Object)INTEGER).put((Object)ClassType.of(Integer.TYPE), (Object)INTEGER).put((Object)ClassType.of(Integer.class), (Object)INTEGER).put((Object)ClassType.of(Long.TYPE), (Object)INTEGER).put((Object)ClassType.of(Long.class), (Object)INTEGER).put((Object)ClassType.of(BigDecimal.class), (Object)DECIMAL).put((Object)ClassType.of(Float.TYPE), (Object)DECIMAL).put((Object)ClassType.of(Float.class), (Object)DECIMAL).put((Object)ClassType.of(Double.TYPE), (Object)DECIMAL).put((Object)ClassType.of(Double.class), (Object)DECIMAL).put((Object)ClassType.of(Boolean.TYPE), (Object)BOOLEAN).put((Object)ClassType.of(Boolean.class), (Object)BOOLEAN).put((Object)ClassType.of(Character.TYPE), (Object)TEXT).put((Object)ClassType.of(String.class), (Object)TEXT).build();
    }
}

