/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.metadata.models;

import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.filter.dialect.ParseException;
import com.yahoo.elide.core.filter.dialect.RSQLFilterDialect;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.datastores.aggregation.metadata.models.Table;
import com.yahoo.elide.modelconfig.model.Named;
import org.apache.commons.lang3.StringUtils;

public interface RequiresFilter
extends Named {
    public Table getTable();

    public String getRequiredFilter();

    default public FilterExpression getRequiredFilter(EntityDictionary dictionary) {
        Type cls = dictionary.getEntityClass(this.getTable().getName(), this.getTable().getVersion());
        RSQLFilterDialect filterDialect = new RSQLFilterDialect(dictionary);
        if (StringUtils.isNotEmpty((CharSequence)this.getRequiredFilter())) {
            try {
                return filterDialect.parseFilterExpression(this.getRequiredFilter(), cls, false, true);
            }
            catch (ParseException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }
}

