/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql;

import com.google.common.base.Preconditions;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.request.Attribute;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.ParameterizedModel;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ValueType;
import com.yahoo.elide.datastores.aggregation.metadata.models.Table;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.Query;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.query.TimeDimensionProjection;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.SQLColumnProjection;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.SQLMetricProjection;
import com.yahoo.elide.datastores.aggregation.timegrains.Day;
import com.yahoo.elide.datastores.aggregation.timegrains.Hour;
import com.yahoo.elide.datastores.aggregation.timegrains.ISOWeek;
import com.yahoo.elide.datastores.aggregation.timegrains.Minute;
import com.yahoo.elide.datastores.aggregation.timegrains.Month;
import com.yahoo.elide.datastores.aggregation.timegrains.Quarter;
import com.yahoo.elide.datastores.aggregation.timegrains.Second;
import com.yahoo.elide.datastores.aggregation.timegrains.Week;
import com.yahoo.elide.datastores.aggregation.timegrains.Year;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;

public class EntityHydrator {
    private final EntityDictionary entityDictionary;
    private final List<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
    private final Query query;

    public EntityHydrator(ResultSet rs, Query query, EntityDictionary entityDictionary) {
        this.query = query;
        this.entityDictionary = entityDictionary;
        Map<String, String> projections = this.query.getMetricProjections().stream().map(SQLMetricProjection.class::cast).filter(ColumnProjection::isProjected).filter(projection -> !projection.getValueType().equals((Object)ValueType.ID)).collect(Collectors.toMap(ColumnProjection::getAlias, ColumnProjection::getSafeAlias));
        projections.putAll(this.query.getAllDimensionProjections().stream().map(SQLColumnProjection.class::cast).filter(ColumnProjection::isProjected).collect(Collectors.toMap(ColumnProjection::getAlias, ColumnProjection::getSafeAlias)));
        try {
            Preconditions.checkArgument((projections.size() == rs.getMetaData().getColumnCount() ? 1 : 0) != 0);
            while (rs.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                for (Map.Entry<String, String> entry : projections.entrySet()) {
                    Object value = rs.getObject(entry.getValue());
                    row.put(entry.getKey(), value);
                }
                this.results.add(row);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public Iterable<Object> hydrate() {
        MutableInt counter = new MutableInt(0);
        List<Object> queryResults = this.getResults().stream().map(result -> this.coerceObjectToEntity((Map<String, Object>)result, counter)).collect(Collectors.toList());
        return queryResults;
    }

    protected Object coerceObjectToEntity(Map<String, Object> result, MutableInt counter) {
        Object entityInstance;
        Table table = this.getBaseTable(this.query);
        Type entityClass = this.entityDictionary.getEntityClass(table.getName(), table.getVersion());
        try {
            entityInstance = entityClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
        result.forEach((fieldName, value) -> {
            ColumnProjection dim = this.query.getColumnProjection((String)fieldName);
            Type fieldType = this.getType(entityClass, dim);
            Attribute attribute = this.projectionToAttribute(dim, fieldType);
            if (entityInstance instanceof ParameterizedModel) {
                ((ParameterizedModel)entityInstance).addAttributeValue(attribute, CoerceUtil.coerce((Object)value, (Type)fieldType));
            } else {
                this.getEntityDictionary().setValue(entityInstance, fieldName, value);
            }
        });
        this.getEntityDictionary().setValue(entityInstance, this.getEntityDictionary().getIdFieldName(entityClass), (Object)counter.getAndIncrement());
        return entityInstance;
    }

    private Table getBaseTable(Query query) {
        Queryable next = query;
        while (next.isNested()) {
            next = next.getSource();
        }
        return (Table)((Object)next.getSource());
    }

    private Attribute projectionToAttribute(ColumnProjection projection, Type valueType) {
        return Attribute.builder().alias(projection.getAlias()).name(projection.getName()).arguments(projection.getArguments().values()).type(valueType).build();
    }

    private Type getType(Type modelType, ColumnProjection column) {
        if (!(column instanceof TimeDimensionProjection)) {
            return this.entityDictionary.getType(modelType, column.getName());
        }
        switch (((TimeDimensionProjection)column).getGrain()) {
            case SECOND: {
                return ClassType.of(Second.class);
            }
            case MINUTE: {
                return ClassType.of(Minute.class);
            }
            case HOUR: {
                return ClassType.of(Hour.class);
            }
            case DAY: {
                return ClassType.of(Day.class);
            }
            case ISOWEEK: {
                return ClassType.of(ISOWeek.class);
            }
            case WEEK: {
                return ClassType.of(Week.class);
            }
            case MONTH: {
                return ClassType.of(Month.class);
            }
            case QUARTER: {
                return ClassType.of(Quarter.class);
            }
            case YEAR: {
                return ClassType.of(Year.class);
            }
        }
        throw new IllegalStateException("Invalid grain type");
    }

    protected EntityDictionary getEntityDictionary() {
        return this.entityDictionary;
    }

    protected List<Map<String, Object>> getResults() {
        return this.results;
    }

    private Query getQuery() {
        return this.query;
    }
}

