/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql.calcite;

import com.yahoo.elide.datastores.aggregation.queryengines.sql.calcite.CalciteUtils;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.calcite.SupportedAggregation;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.dialects.SQLDialect;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;

public class CalciteOuterAggregationExtractor
extends SqlBasicVisitor<SqlNode> {
    private SQLDialect dialect;
    private Queue<List<String>> substitutions;

    public CalciteOuterAggregationExtractor(SQLDialect dialect, List<List<String>> substitutions) {
        this.dialect = dialect;
        this.substitutions = new ArrayDeque<List<String>>();
        this.substitutions.addAll(substitutions);
    }

    public SqlNode visit(SqlCall call) {
        String operatorName = call.getOperator().getName();
        SupportedAggregation operator = this.dialect.getSupportedAggregation(operatorName);
        if (operator != null) {
            List<String> expressionsSubs = this.substitutions.remove();
            String postAggExpression = operator.getOuterAggregation(expressionsSubs.toArray(new String[0]));
            SqlParser sqlParser = SqlParser.create((String)postAggExpression, (SqlParser.Config)CalciteUtils.constructParserConfig(this.dialect));
            try {
                return sqlParser.parseExpression();
            }
            catch (SqlParseException e) {
                throw new IllegalStateException(e);
            }
        }
        for (int idx = 0; idx < call.getOperandList().size(); ++idx) {
            SqlNode operand = (SqlNode)call.getOperandList().get(idx);
            call.setOperand(idx, (SqlNode)operand.accept((SqlVisitor)this));
        }
        return call;
    }

    public SqlNode visit(SqlNodeList nodeList) {
        return nodeList;
    }

    public SqlNode visit(SqlLiteral literal) {
        return literal;
    }

    public SqlNode visit(SqlIdentifier id) {
        return id;
    }

    public SqlNode visit(SqlDataTypeSpec type) {
        return type;
    }

    public SqlNode visit(SqlDynamicParam param) {
        return param;
    }

    public SqlNode visit(SqlIntervalQualifier intervalQualifier) {
        return intervalQualifier;
    }
}

