/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql.query;

import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ColumnType;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ValueType;
import com.yahoo.elide.datastores.aggregation.metadata.models.Dimension;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.DimensionProjection;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.SQLColumnProjection;
import java.util.Map;

public final class SQLDimensionProjection
implements SQLColumnProjection,
DimensionProjection {
    private final String name;
    private final ValueType valueType;
    private final ColumnType columnType;
    private final String expression;
    private final String alias;
    private final Map<String, Argument> arguments;
    private final boolean projected;

    public SQLDimensionProjection(Dimension dimension, String alias, Map<String, Argument> arguments, boolean projected) {
        this.name = dimension.getName();
        this.expression = dimension.getExpression();
        this.valueType = dimension.getValueType();
        this.columnType = dimension.getColumnType();
        this.alias = alias;
        this.arguments = arguments;
        this.projected = projected;
    }

    public SQLDimensionProjection withExpression(String expression, boolean projected) {
        return new SQLDimensionProjection(this.name, this.valueType, this.columnType, expression, this.alias, this.arguments, projected);
    }

    @Override
    public boolean isProjected() {
        return this.projected;
    }

    public SQLDimensionProjection withProjected(boolean projected) {
        return new SQLDimensionProjection(this.name, this.valueType, this.columnType, this.expression, this.alias, this.arguments, projected);
    }

    @Override
    public ColumnProjection withArguments(Map<String, Argument> arguments) {
        return new SQLDimensionProjection(this.name, this.valueType, this.columnType, this.expression, this.alias, arguments, this.projected);
    }

    public static SQLDimensionProjectionBuilder builder() {
        return new SQLDimensionProjectionBuilder();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public ColumnType getColumnType() {
        return this.columnType;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public Map<String, Argument> getArguments() {
        return this.arguments;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SQLDimensionProjection)) {
            return false;
        }
        SQLDimensionProjection other = (SQLDimensionProjection)o;
        if (this.isProjected() != other.isProjected()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ValueType this$valueType = this.getValueType();
        ValueType other$valueType = other.getValueType();
        if (this$valueType == null ? other$valueType != null : !((Object)((Object)this$valueType)).equals((Object)other$valueType)) {
            return false;
        }
        ColumnType this$columnType = this.getColumnType();
        ColumnType other$columnType = other.getColumnType();
        if (this$columnType == null ? other$columnType != null : !((Object)((Object)this$columnType)).equals((Object)other$columnType)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        Map<String, Argument> this$arguments = this.getArguments();
        Map<String, Argument> other$arguments = other.getArguments();
        return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isProjected() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ValueType $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 43 : ((Object)((Object)$valueType)).hashCode());
        ColumnType $columnType = this.getColumnType();
        result = result * 59 + ($columnType == null ? 43 : ((Object)((Object)$columnType)).hashCode());
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        Map<String, Argument> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        return result;
    }

    public String toString() {
        return "SQLDimensionProjection(name=" + this.getName() + ", valueType=" + (Object)((Object)this.getValueType()) + ", columnType=" + (Object)((Object)this.getColumnType()) + ", expression=" + this.getExpression() + ", alias=" + this.getAlias() + ", arguments=" + this.getArguments() + ", projected=" + this.isProjected() + ")";
    }

    public SQLDimensionProjection(String name, ValueType valueType, ColumnType columnType, String expression, String alias, Map<String, Argument> arguments, boolean projected) {
        this.name = name;
        this.valueType = valueType;
        this.columnType = columnType;
        this.expression = expression;
        this.alias = alias;
        this.arguments = arguments;
        this.projected = projected;
    }

    public static class SQLDimensionProjectionBuilder {
        private String name;
        private ValueType valueType;
        private ColumnType columnType;
        private String expression;
        private String alias;
        private Map<String, Argument> arguments;
        private boolean projected;

        SQLDimensionProjectionBuilder() {
        }

        public SQLDimensionProjectionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SQLDimensionProjectionBuilder valueType(ValueType valueType) {
            this.valueType = valueType;
            return this;
        }

        public SQLDimensionProjectionBuilder columnType(ColumnType columnType) {
            this.columnType = columnType;
            return this;
        }

        public SQLDimensionProjectionBuilder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public SQLDimensionProjectionBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public SQLDimensionProjectionBuilder arguments(Map<String, Argument> arguments) {
            this.arguments = arguments;
            return this;
        }

        public SQLDimensionProjectionBuilder projected(boolean projected) {
            this.projected = projected;
            return this;
        }

        public SQLDimensionProjection build() {
            return new SQLDimensionProjection(this.name, this.valueType, this.columnType, this.expression, this.alias, this.arguments, this.projected);
        }

        public String toString() {
            return "SQLDimensionProjection.SQLDimensionProjectionBuilder(name=" + this.name + ", valueType=" + (Object)((Object)this.valueType) + ", columnType=" + (Object)((Object)this.columnType) + ", expression=" + this.expression + ", alias=" + this.alias + ", arguments=" + this.arguments + ", projected=" + this.projected + ")";
        }
    }
}

