/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql.query;

import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ColumnType;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ValueType;
import com.yahoo.elide.datastores.aggregation.metadata.models.Metric;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.MetricProjection;
import com.yahoo.elide.datastores.aggregation.query.Query;
import com.yahoo.elide.datastores.aggregation.query.QueryPlan;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.calcite.CalciteInnerAggregationExtractor;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.calcite.CalciteOuterAggregationExtractor;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.calcite.CalciteUtils;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.dialects.SQLDialect;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.SQLColumnProjection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.commons.lang3.tuple.Pair;

public class SQLMetricProjection
implements MetricProjection,
SQLColumnProjection {
    private static final Pattern QUERY_PATTERN = Pattern.compile(".*\\{\\{.*\\}\\}.*");
    private String name;
    private ValueType valueType;
    private ColumnType columnType;
    private String expression;
    private String alias;
    private Map<String, Argument> arguments;
    private boolean projected;

    @Override
    public QueryPlan resolve(Query query) {
        return QueryPlan.builder().source(query.getSource()).metricProjection(this).build();
    }

    public SQLMetricProjection(String name, ValueType valueType, ColumnType columnType, String expression, String alias, Map<String, Argument> arguments, boolean projected) {
        this.name = name;
        this.valueType = valueType;
        this.columnType = columnType;
        this.expression = expression;
        this.alias = alias;
        this.arguments = arguments;
        this.projected = projected;
    }

    public SQLMetricProjection(Metric metric, String alias, Map<String, Argument> arguments) {
        this(metric.getName(), metric.getValueType(), metric.getColumnType(), metric.getExpression(), alias, arguments, true);
    }

    @Override
    public String toSQL(Queryable query, MetaDataStore metaDataStore) {
        if (QUERY_PATTERN.matcher(this.expression).matches()) {
            return SQLColumnProjection.super.toSQL(query, metaDataStore);
        }
        return this.expression;
    }

    @Override
    public boolean canNest(Queryable source, MetaDataStore store) {
        boolean requiresJoin = SQLColumnProjection.requiresJoin(source, this, store);
        if (requiresJoin) {
            return false;
        }
        return SQLColumnProjection.super.canNest(source, store);
    }

    @Override
    public Pair<ColumnProjection, Set<ColumnProjection>> nest(Queryable source, MetaDataStore metaDataStore, boolean joinInOuter) {
        SqlNode node;
        SQLDialect dialect = source.getConnectionDetails().getDialect();
        String sql = this.toSQL(source, metaDataStore);
        SqlParser sqlParser = SqlParser.create((String)sql, (SqlParser.Config)CalciteUtils.constructParserConfig(dialect));
        try {
            node = sqlParser.parseExpression();
        }
        catch (SqlParseException e) {
            throw new IllegalStateException(e);
        }
        CalciteInnerAggregationExtractor innerExtractor = new CalciteInnerAggregationExtractor(dialect);
        List innerAggExpressions = (List)node.accept((SqlVisitor)innerExtractor);
        List<List<String>> innerAggLabels = innerAggExpressions.stream().map(list -> list.stream().map(expression -> SQLMetricProjection.getAggregationLabel(dialect.getCalciteDialect(), expression)).collect(Collectors.toList())).collect(Collectors.toList());
        LinkedHashSet<SQLMetricProjection> innerAggProjections = new LinkedHashSet<SQLMetricProjection>();
        Iterator labelIt = innerAggLabels.stream().flatMap(Collection::stream).iterator();
        Iterator expressionIt = innerAggExpressions.stream().flatMap(Collection::stream).iterator();
        while (labelIt.hasNext() && expressionIt.hasNext()) {
            String innerAggExpression = (String)expressionIt.next();
            String innerAggLabel = (String)labelIt.next();
            innerAggProjections.add(SQLMetricProjection.builder().projected(true).name(innerAggLabel).alias(innerAggLabel).expression(innerAggExpression).columnType(this.columnType).valueType(this.valueType).arguments(this.arguments).build());
        }
        CalciteOuterAggregationExtractor outerExtractor = new CalciteOuterAggregationExtractor(dialect, innerAggLabels);
        SqlNode transformedParseTree = (SqlNode)node.accept((SqlVisitor)outerExtractor);
        String outerAggExpression = transformedParseTree.toSqlString(dialect.getCalciteDialect()).getSql();
        outerAggExpression = outerAggExpression.replaceAll(dialect.getBeginQuote() + "?(" + SQLMetricProjection.getAggregationLabelPrefix(dialect.getCalciteDialect()) + "\\w+)" + dialect.getEndQuote() + "?", "{{\\$$1}}");
        boolean inProjection = source.getColumnProjection(this.name, this.arguments, true) != null;
        SQLMetricProjection outerProjection = SQLMetricProjection.builder().projected(inProjection).expression(outerAggExpression).name(this.name).alias(this.alias).valueType(this.valueType).columnType(this.columnType).arguments(this.arguments).build();
        return Pair.of((Object)outerProjection, innerAggProjections);
    }

    public SQLMetricProjection withProjected(boolean projected) {
        return new SQLMetricProjection(this.name, this.valueType, this.columnType, this.expression, this.alias, this.arguments, projected);
    }

    @Override
    public boolean isProjected() {
        return this.projected;
    }

    public SQLMetricProjection withExpression(String expression, boolean projected) {
        return new SQLMetricProjection(this.name, this.valueType, this.columnType, expression, this.alias, this.arguments, projected);
    }

    private static String getAggregationLabelPrefix(SqlDialect dialect) {
        if (dialect.getUnquotedCasing().equals((Object)Casing.TO_LOWER)) {
            return "inner_agg_";
        }
        return "INNER_AGG_";
    }

    private static String getAggregationLabel(SqlDialect dialect, String expression) {
        return SQLMetricProjection.getAggregationLabelPrefix(dialect) + (expression.hashCode() & 0xFFFFFFF);
    }

    @Override
    public SQLMetricProjection withArguments(Map<String, Argument> arguments) {
        return new SQLMetricProjection(this.name, this.valueType, this.columnType, this.expression, this.alias, arguments, this.projected);
    }

    private static boolean $default$projected() {
        return true;
    }

    public static SQLMetricProjectionBuilder builder() {
        return new SQLMetricProjectionBuilder();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public ColumnType getColumnType() {
        return this.columnType;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public Map<String, Argument> getArguments() {
        return this.arguments;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public void setColumnType(ColumnType columnType) {
        this.columnType = columnType;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setArguments(Map<String, Argument> arguments) {
        this.arguments = arguments;
    }

    public void setProjected(boolean projected) {
        this.projected = projected;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SQLMetricProjection)) {
            return false;
        }
        SQLMetricProjection other = (SQLMetricProjection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isProjected() != other.isProjected()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ValueType this$valueType = this.getValueType();
        ValueType other$valueType = other.getValueType();
        if (this$valueType == null ? other$valueType != null : !((Object)((Object)this$valueType)).equals((Object)other$valueType)) {
            return false;
        }
        ColumnType this$columnType = this.getColumnType();
        ColumnType other$columnType = other.getColumnType();
        if (this$columnType == null ? other$columnType != null : !((Object)((Object)this$columnType)).equals((Object)other$columnType)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        Map<String, Argument> this$arguments = this.getArguments();
        Map<String, Argument> other$arguments = other.getArguments();
        return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SQLMetricProjection;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isProjected() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ValueType $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 43 : ((Object)((Object)$valueType)).hashCode());
        ColumnType $columnType = this.getColumnType();
        result = result * 59 + ($columnType == null ? 43 : ((Object)((Object)$columnType)).hashCode());
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        Map<String, Argument> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        return result;
    }

    public String toString() {
        return "SQLMetricProjection(name=" + this.getName() + ", valueType=" + (Object)((Object)this.getValueType()) + ", columnType=" + (Object)((Object)this.getColumnType()) + ", expression=" + this.getExpression() + ", alias=" + this.getAlias() + ", arguments=" + this.getArguments() + ", projected=" + this.isProjected() + ")";
    }

    public static class SQLMetricProjectionBuilder {
        private String name;
        private ValueType valueType;
        private ColumnType columnType;
        private String expression;
        private String alias;
        private Map<String, Argument> arguments;
        private boolean projected$set;
        private boolean projected$value;
        private boolean projected;

        SQLMetricProjectionBuilder() {
        }

        public SQLMetricProjectionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SQLMetricProjectionBuilder valueType(ValueType valueType) {
            this.valueType = valueType;
            return this;
        }

        public SQLMetricProjectionBuilder columnType(ColumnType columnType) {
            this.columnType = columnType;
            return this;
        }

        public SQLMetricProjectionBuilder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public SQLMetricProjectionBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public SQLMetricProjectionBuilder arguments(Map<String, Argument> arguments) {
            this.arguments = arguments;
            return this;
        }

        public SQLMetricProjectionBuilder projected(boolean projected) {
            this.projected$value = projected;
            this.projected$set = true;
            return this;
        }

        public SQLMetricProjection build() {
            boolean projected$value = this.projected$value;
            if (!this.projected$set) {
                projected$value = SQLMetricProjection.$default$projected();
            }
            return new SQLMetricProjection(this.name, this.valueType, this.columnType, this.expression, this.alias, this.arguments, projected$value);
        }

        public String toString() {
            return "SQLMetricProjection.SQLMetricProjectionBuilder(name=" + this.name + ", valueType=" + (Object)((Object)this.valueType) + ", columnType=" + (Object)((Object)this.columnType) + ", expression=" + this.expression + ", alias=" + this.alias + ", arguments=" + this.arguments + ", projected$value=" + this.projected$value + ")";
        }
    }
}

