/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.timegrains;

import com.yahoo.elide.core.utils.coerce.converters.ElideTypeConverter;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import com.yahoo.elide.datastores.aggregation.metadata.enums.TimeGrain;
import com.yahoo.elide.datastores.aggregation.timegrains.Time;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class Hour
extends Time {
    public static final String FORMAT = "yyyy-MM-dd'T'HH";
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH").withZone(ZoneOffset.systemDefault());

    public Hour(Date date) {
        super(date, true, true, true, true, false, false, Hour.getSerializer(TimeGrain.HOUR));
    }

    public Hour(LocalDateTime date) {
        super(date, true, true, true, true, false, false, Hour.getSerializer(TimeGrain.HOUR));
    }

    @ElideTypeConverter(type=Hour.class, name="Hour")
    public static class HourSerde
    implements Serde<Object, Hour> {
        public Hour deserialize(Object val) {
            if (val instanceof Date) {
                return new Hour((Date)val);
            }
            return new Hour(LocalDateTime.parse(val.toString(), FORMATTER));
        }

        public String serialize(Hour val) {
            return val.serializer.format(val);
        }
    }
}

