/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.dynamic;

import com.yahoo.elide.annotation.Exclude;
import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Field;
import com.yahoo.elide.core.type.Method;
import com.yahoo.elide.core.type.Package;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.datastores.aggregation.annotation.ArgumentDefinition;
import com.yahoo.elide.datastores.aggregation.annotation.CardinalitySize;
import com.yahoo.elide.datastores.aggregation.annotation.ColumnMeta;
import com.yahoo.elide.datastores.aggregation.annotation.DimensionFormula;
import com.yahoo.elide.datastores.aggregation.annotation.Join;
import com.yahoo.elide.datastores.aggregation.annotation.JoinType;
import com.yahoo.elide.datastores.aggregation.annotation.MetricFormula;
import com.yahoo.elide.datastores.aggregation.annotation.TableMeta;
import com.yahoo.elide.datastores.aggregation.annotation.TableSource;
import com.yahoo.elide.datastores.aggregation.annotation.Temporal;
import com.yahoo.elide.datastores.aggregation.annotation.TimeGrainDefinition;
import com.yahoo.elide.datastores.aggregation.dynamic.DynamicModelInstance;
import com.yahoo.elide.datastores.aggregation.dynamic.FieldType;
import com.yahoo.elide.datastores.aggregation.dynamic.NamespacePackage;
import com.yahoo.elide.datastores.aggregation.metadata.enums.TimeGrain;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ValueType;
import com.yahoo.elide.datastores.aggregation.query.DefaultMetricProjectionMaker;
import com.yahoo.elide.datastores.aggregation.query.MetricProjectionMaker;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.annotation.FromSubquery;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.annotation.FromTable;
import com.yahoo.elide.datastores.aggregation.timegrains.Time;
import com.yahoo.elide.modelconfig.model.Argument;
import com.yahoo.elide.modelconfig.model.Dimension;
import com.yahoo.elide.modelconfig.model.Grain;
import com.yahoo.elide.modelconfig.model.Join;
import com.yahoo.elide.modelconfig.model.Measure;
import com.yahoo.elide.modelconfig.model.Table;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import org.apache.commons.lang3.StringUtils;

public class TableType
implements Type<DynamicModelInstance> {
    public static final Pattern REFERENCE_PARENTHESES = Pattern.compile("\\{\\{(.+?)}}");
    private static final String SPACE = " ";
    public static final Pattern NEWLINE = Pattern.compile(System.lineSeparator(), 16);
    protected Table table;
    private Map<Class<? extends Annotation>, Annotation> annotations;
    private Map<String, Field> fields;
    private Package namespace;

    public TableType(Table table) {
        this(table, NamespacePackage.DEFAULT_NAMESPACE);
    }

    public TableType(Table table, Package namespace) {
        this.namespace = namespace;
        this.table = table;
        this.annotations = TableType.buildAnnotations(table);
        this.fields = TableType.buildFields(table);
    }

    public String getCanonicalName() {
        return this.getName();
    }

    public String getSimpleName() {
        return this.getName();
    }

    public String getName() {
        return this.table.getName();
    }

    public Type<?> getSuperclass() {
        return null;
    }

    public boolean isPrimitive() {
        return false;
    }

    public Package getPackage() {
        return this.namespace;
    }

    public Method[] getMethods() {
        return new Method[0];
    }

    public Method[] getDeclaredMethods() {
        return new Method[0];
    }

    public Field[] getFields() {
        return this.fields.values().toArray(new Field[0]);
    }

    public Field[] getDeclaredFields() {
        return this.getFields();
    }

    public Field getDeclaredField(String name) throws NoSuchFieldException {
        if (this.fields.containsKey(name)) {
            return this.fields.get(name);
        }
        return null;
    }

    public Method[] getConstructors() {
        return new Method[0];
    }

    public boolean isParameterized() {
        return false;
    }

    public boolean hasSuperType() {
        return false;
    }

    public DynamicModelInstance newInstance() throws InstantiationException, IllegalAccessException {
        return new DynamicModelInstance(this);
    }

    public boolean isEnum() {
        return false;
    }

    public DynamicModelInstance[] getEnumConstants() {
        return null;
    }

    public Optional<Class<DynamicModelInstance>> getUnderlyingClass() {
        return Optional.empty();
    }

    public boolean isAssignableFrom(Type cls) {
        return false;
    }

    public boolean isAnnotationPresent(Class annotationClass) {
        return this.annotations.containsKey(annotationClass);
    }

    public Annotation getAnnotation(Class annotationClass) {
        if (this.annotations.containsKey(annotationClass)) {
            return this.annotations.get(annotationClass);
        }
        return null;
    }

    public Annotation getDeclaredAnnotation(Class annotationClass) {
        return this.getAnnotation(annotationClass);
    }

    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
        if (this.annotations.containsKey(annotationClass)) {
            Annotation[] result = (Annotation[])Array.newInstance(annotationClass, 1);
            result[0] = this.annotations.get(annotationClass);
            return result;
        }
        return (Annotation[])Array.newInstance(annotationClass, 0);
    }

    public Method getMethod(String name, Type<?> ... parameterTypes) throws NoSuchMethodException {
        throw new NoSuchMethodException();
    }

    public void resolveJoins(Map<String, Type<?>> tableTypes) {
        this.table.getJoins().forEach(join -> {
            Type joinTableType = (Type)tableTypes.get(join.getTo());
            this.fields.put(join.getName(), new FieldType(join.getName(), joinTableType, TableType.buildAnnotations(join)));
        });
    }

    private static Map<Class<? extends Annotation>, Annotation> buildAnnotations(final com.yahoo.elide.modelconfig.model.Join join) {
        HashMap<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
        annotations.put(Join.class, new Join(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Join.class;
            }

            @Override
            public String value() {
                return TableType.trimColumnReferences(join.getDefinition());
            }

            @Override
            public JoinType type() {
                if (join.getType() == null) {
                    return JoinType.LEFT;
                }
                return JoinType.valueOf(join.getType().name());
            }

            @Override
            public boolean toOne() {
                return join.getKind() == Join.Kind.TOONE;
            }
        });
        return annotations;
    }

    private static Map<Class<? extends Annotation>, Annotation> buildAnnotations(final Table table) {
        HashMap<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
        if (Boolean.TRUE.equals(table.getHidden())) {
            annotations.put((Class<? extends Annotation>)Exclude.class, (Annotation)((Object)new ExcludeAnnotation()));
        } else {
            annotations.put((Class<? extends Annotation>)Include.class, (Annotation)TableType.getIncludeAnnotation(table));
        }
        if (table.getSql() != null && !table.getSql().isEmpty()) {
            annotations.put(FromSubquery.class, new FromSubquery(){

                @Override
                public Class<? extends Annotation> annotationType() {
                    return FromSubquery.class;
                }

                @Override
                public String sql() {
                    return table.getSql();
                }

                @Override
                public String dbConnectionName() {
                    return table.getDbConnectionName();
                }
            });
        } else {
            annotations.put(FromTable.class, new FromTable(){

                @Override
                public Class<? extends Annotation> annotationType() {
                    return FromTable.class;
                }

                @Override
                public String name() {
                    String tableName = table.getTable();
                    if (table.getSchema() != null && !table.getSchema().isEmpty()) {
                        return table.getSchema() + "." + tableName;
                    }
                    return tableName;
                }

                @Override
                public String dbConnectionName() {
                    return table.getDbConnectionName();
                }
            });
        }
        annotations.put(TableMeta.class, new TableMeta(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return TableMeta.class;
            }

            @Override
            public String friendlyName() {
                return table.getFriendlyName();
            }

            @Override
            public String description() {
                return table.getDescription();
            }

            @Override
            public String category() {
                return table.getCategory();
            }

            @Override
            public String[] hints() {
                return table.getHints().toArray(new String[0]);
            }

            @Override
            public String[] tags() {
                return table.getTags().toArray(new String[0]);
            }

            @Override
            public String filterTemplate() {
                return table.getFilterTemplate();
            }

            @Override
            public boolean isFact() {
                return table.getIsFact();
            }

            @Override
            public CardinalitySize size() {
                if (table.getCardinality() == null || table.getCardinality().isEmpty()) {
                    return CardinalitySize.UNKNOWN;
                }
                return CardinalitySize.valueOf(table.getCardinality().toUpperCase(Locale.ENGLISH));
            }

            @Override
            public ArgumentDefinition[] arguments() {
                return TableType.getArgumentDefinitions(table.getArguments());
            }
        });
        final String readPermission = table.getReadAccess();
        if (StringUtils.isNotEmpty((CharSequence)readPermission)) {
            annotations.put(ReadPermission.class, (Annotation)new ReadPermission(){

                public Class<? extends Annotation> annotationType() {
                    return ReadPermission.class;
                }

                public String expression() {
                    return readPermission;
                }
            });
        }
        return annotations;
    }

    private static ArgumentDefinition[] getArgumentDefinitions(List<Argument> arguments) {
        int numArguments = arguments == null ? 0 : arguments.size();
        ArgumentDefinition[] definitions = new ArgumentDefinition[numArguments];
        for (int idx = 0; idx < numArguments; ++idx) {
            final Argument argument = arguments.get(idx);
            definitions[idx] = new ArgumentDefinition(){

                @Override
                public String name() {
                    return argument.getName();
                }

                @Override
                public String description() {
                    return argument.getDescription();
                }

                @Override
                public ValueType type() {
                    return ValueType.valueOf(argument.getType().toString());
                }

                @Override
                public TableSource tableSource() {
                    return TableType.buildTableSource(argument.getTableSource());
                }

                @Override
                public String[] values() {
                    return argument.getValues().toArray(new String[0]);
                }

                @Override
                public String defaultValue() {
                    return argument.getDefaultValue().toString();
                }

                @Override
                public Class<? extends Annotation> annotationType() {
                    return ArgumentDefinition.class;
                }
            };
        }
        return definitions;
    }

    private static Map<Class<? extends Annotation>, Annotation> buildAnnotations(final Measure measure) {
        HashMap<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
        if (Boolean.TRUE.equals(measure.getHidden())) {
            annotations.put((Class<? extends Annotation>)Exclude.class, (Annotation)((Object)new ExcludeAnnotation()));
        }
        annotations.put(ColumnMeta.class, new ColumnMeta(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return ColumnMeta.class;
            }

            @Override
            public String friendlyName() {
                return measure.getFriendlyName();
            }

            @Override
            public String description() {
                return measure.getDescription();
            }

            @Override
            public String category() {
                return measure.getCategory();
            }

            @Override
            public TableSource tableSource() {
                return TableType.buildTableSource(null);
            }

            @Override
            public String[] tags() {
                return measure.getTags().toArray(new String[0]);
            }

            @Override
            public String[] values() {
                return new String[0];
            }

            @Override
            public CardinalitySize size() {
                return CardinalitySize.UNKNOWN;
            }
        });
        annotations.put(MetricFormula.class, new MetricFormula(){

            @Override
            public ArgumentDefinition[] arguments() {
                return TableType.getArgumentDefinitions(measure.getArguments());
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return MetricFormula.class;
            }

            @Override
            public String value() {
                return TableType.trimColumnReferences(measure.getDefinition());
            }

            @Override
            public Class<? extends MetricProjectionMaker> maker() {
                if (measure.getMaker() == null || measure.getMaker().isEmpty()) {
                    return DefaultMetricProjectionMaker.class;
                }
                try {
                    return Class.forName(measure.getMaker());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
        final String readPermission = measure.getReadAccess();
        if (StringUtils.isNotEmpty((CharSequence)readPermission)) {
            annotations.put(ReadPermission.class, (Annotation)new ReadPermission(){

                public Class<? extends Annotation> annotationType() {
                    return ReadPermission.class;
                }

                public String expression() {
                    return readPermission;
                }
            });
        }
        return annotations;
    }

    private static TableSource buildTableSource(final com.yahoo.elide.modelconfig.model.TableSource source) {
        if (source == null) {
            return TableType.buildTableSource(new com.yahoo.elide.modelconfig.model.TableSource("", "default", "", new HashSet()));
        }
        return new TableSource(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return TableSource.class;
            }

            @Override
            public String table() {
                return source.getTable();
            }

            @Override
            public String namespace() {
                return source.getNamespace();
            }

            @Override
            public String column() {
                return source.getColumn();
            }

            @Override
            public String[] suggestionColumns() {
                return source.getSuggestionColumns().toArray(new String[0]);
            }
        };
    }

    private static Map<Class<? extends Annotation>, Annotation> buildAnnotations(final Dimension dimension) {
        HashMap<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
        if (Boolean.TRUE.equals(dimension.getHidden())) {
            annotations.put((Class<? extends Annotation>)Exclude.class, (Annotation)((Object)new ExcludeAnnotation()));
        }
        annotations.put(ColumnMeta.class, new ColumnMeta(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return ColumnMeta.class;
            }

            @Override
            public String friendlyName() {
                return dimension.getFriendlyName();
            }

            @Override
            public String description() {
                return dimension.getDescription();
            }

            @Override
            public String category() {
                return dimension.getCategory();
            }

            @Override
            public TableSource tableSource() {
                return TableType.buildTableSource(dimension.getTableSource());
            }

            @Override
            public String[] tags() {
                return dimension.getTags().toArray(new String[0]);
            }

            @Override
            public String[] values() {
                return dimension.getValues().toArray(new String[0]);
            }

            @Override
            public CardinalitySize size() {
                if (dimension.getCardinality() == null || dimension.getCardinality().isEmpty()) {
                    return CardinalitySize.UNKNOWN;
                }
                return CardinalitySize.valueOf(dimension.getCardinality().toUpperCase(Locale.ENGLISH));
            }
        });
        annotations.put(DimensionFormula.class, new DimensionFormula(){

            @Override
            public ArgumentDefinition[] arguments() {
                return TableType.getArgumentDefinitions(dimension.getArguments());
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return DimensionFormula.class;
            }

            @Override
            public String value() {
                return TableType.trimColumnReferences(dimension.getDefinition());
            }
        });
        final String readPermission = dimension.getReadAccess();
        if (StringUtils.isNotEmpty((CharSequence)readPermission)) {
            annotations.put(ReadPermission.class, (Annotation)new ReadPermission(){

                public Class<? extends Annotation> annotationType() {
                    return ReadPermission.class;
                }

                public String expression() {
                    return readPermission;
                }
            });
        }
        if (dimension.getType() == com.yahoo.elide.modelconfig.model.Type.TIME) {
            annotations.put(Temporal.class, new Temporal(){

                @Override
                public Class<? extends Annotation> annotationType() {
                    return Temporal.class;
                }

                @Override
                public TimeGrainDefinition[] grains() {
                    int numGrains = dimension.getGrains() == null ? 0 : dimension.getGrains().size();
                    TimeGrainDefinition[] definitions = new TimeGrainDefinition[numGrains];
                    for (int idx = 0; idx < numGrains; ++idx) {
                        final Grain grain = (Grain)dimension.getGrains().get(idx);
                        definitions[idx] = new TimeGrainDefinition(){

                            @Override
                            public Class<? extends Annotation> annotationType() {
                                return TimeGrainDefinition.class;
                            }

                            @Override
                            public TimeGrain grain() {
                                if (grain.getType() == null) {
                                    return TimeGrain.DAY;
                                }
                                return TimeGrain.valueOf(grain.getType().name());
                            }

                            @Override
                            public String expression() {
                                String sql = grain.getSql();
                                if (StringUtils.isEmpty((CharSequence)sql)) {
                                    return "{{$$column.expr}}";
                                }
                                return grain.getSql();
                            }
                        };
                    }
                    return definitions;
                }

                @Override
                public String timeZone() {
                    return "UTC";
                }
            });
        }
        return annotations;
    }

    private static Map<String, Field> buildFields(Table table) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        fields.put("id", TableType.buildIdField());
        table.getDimensions().forEach(dimension -> {
            Field cfr_ignored_0 = fields.put(dimension.getName(), new FieldType(dimension.getName(), TableType.getFieldType(dimension.getType()), TableType.buildAnnotations(dimension)));
        });
        table.getMeasures().forEach(measure -> {
            Field cfr_ignored_0 = fields.put(measure.getName(), new FieldType(measure.getName(), TableType.getFieldType(measure.getType()), TableType.buildAnnotations(measure)));
        });
        return fields;
    }

    private static Field buildIdField() {
        HashMap<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
        annotations.put((Class<? extends Annotation>)Id.class, (Annotation)new Id(){

            public Class<? extends Annotation> annotationType() {
                return Id.class;
            }
        });
        annotations.put((Class<? extends Annotation>)GeneratedValue.class, (Annotation)new GeneratedValue(){

            public GenerationType strategy() {
                return GenerationType.AUTO;
            }

            public String generator() {
                return "";
            }

            public Class<? extends Annotation> annotationType() {
                return GeneratedValue.class;
            }
        });
        annotations.put(ColumnMeta.class, new ColumnMeta(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return ColumnMeta.class;
            }

            @Override
            public String friendlyName() {
                return "Row Number";
            }

            @Override
            public String description() {
                return "Row number for each record returned by a query.";
            }

            @Override
            public String category() {
                return null;
            }

            @Override
            public TableSource tableSource() {
                return TableType.buildTableSource(null);
            }

            @Override
            public String[] tags() {
                return new String[0];
            }

            @Override
            public String[] values() {
                return new String[0];
            }

            @Override
            public CardinalitySize size() {
                return CardinalitySize.UNKNOWN;
            }
        });
        return new FieldType("id", (Type)ClassType.LONG_TYPE, annotations);
    }

    private static Type getFieldType(com.yahoo.elide.modelconfig.model.Type inputType) {
        switch (inputType) {
            case TIME: {
                return Time.TIME_TYPE;
            }
            case TEXT: {
                return ClassType.STRING_TYPE;
            }
            case MONEY: {
                return ClassType.BIGDECIMAL_TYPE;
            }
            case BOOLEAN: {
                return ClassType.BOOLEAN_TYPE;
            }
            case DECIMAL: {
                return ClassType.BIGDECIMAL_TYPE;
            }
            case INTEGER: {
                return ClassType.LONG_TYPE;
            }
            case COORDINATE: {
                return ClassType.STRING_TYPE;
            }
        }
        return ClassType.STRING_TYPE;
    }

    private static String trimColumnReferences(String str) {
        String expr = TableType.replaceNewlineWithSpace(str);
        Matcher matcher = REFERENCE_PARENTHESES.matcher(expr);
        while (matcher.find()) {
            String reference = matcher.group(1);
            expr = expr.replace(reference, reference.trim());
        }
        return expr;
    }

    private static String replaceNewlineWithSpace(String str) {
        return str == null ? null : NEWLINE.matcher(str).replaceAll(SPACE);
    }

    private static Include getIncludeAnnotation(final Table table) {
        return new Include(){

            public Class<? extends Annotation> annotationType() {
                return Include.class;
            }

            public boolean rootLevel() {
                return true;
            }

            public String description() {
                return table.getDescription();
            }

            public String friendlyName() {
                return table.getFriendlyName();
            }

            public String name() {
                return table.getName();
            }
        };
    }

    private static final class ExcludeAnnotation
    implements Exclude {
        private ExcludeAnnotation() {
        }

        public Class<? extends Annotation> annotationType() {
            return Exclude.class;
        }
    }
}

