/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.filter.visitor;

import com.google.common.base.Preconditions;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.NotFilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.filter.visitors.FilterExpressionNormalizationVisitor;
import java.util.regex.Pattern;

public class MatchesTemplateVisitor
implements FilterExpressionVisitor<Boolean> {
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("\\{\\{\\w*\\}\\}");
    private FilterExpression expressionToMatch;

    public Boolean visitPredicate(FilterPredicate filterPredicate) {
        return MatchesTemplateVisitor.matches(this.expressionToMatch, (FilterExpression)filterPredicate);
    }

    public Boolean visitAndExpression(AndFilterExpression expression) {
        return MatchesTemplateVisitor.matches(this.expressionToMatch, (FilterExpression)expression) || (Boolean)expression.getLeft().accept((FilterExpressionVisitor)this) != false || (Boolean)expression.getRight().accept((FilterExpressionVisitor)this) != false;
    }

    public Boolean visitOrExpression(OrFilterExpression expression) {
        return MatchesTemplateVisitor.matches(this.expressionToMatch, (FilterExpression)expression);
    }

    public Boolean visitNotExpression(NotFilterExpression expression) {
        return MatchesTemplateVisitor.matches(this.expressionToMatch, (FilterExpression)expression);
    }

    private static boolean matches(FilterExpression a, FilterExpression b) {
        if (!a.getClass().equals(b.getClass())) {
            return false;
        }
        if (a instanceof AndFilterExpression) {
            AndFilterExpression andA = (AndFilterExpression)a;
            AndFilterExpression andB = (AndFilterExpression)b;
            return MatchesTemplateVisitor.matches(andA.getLeft(), andB.getLeft()) && MatchesTemplateVisitor.matches(andA.getRight(), andB.getRight());
        }
        if (a instanceof OrFilterExpression) {
            OrFilterExpression orA = (OrFilterExpression)a;
            OrFilterExpression orB = (OrFilterExpression)b;
            return MatchesTemplateVisitor.matches(orA.getLeft(), orB.getLeft()) && MatchesTemplateVisitor.matches(orA.getRight(), orB.getRight());
        }
        if (a instanceof NotFilterExpression) {
            NotFilterExpression notA = (NotFilterExpression)a;
            NotFilterExpression notB = (NotFilterExpression)b;
            return MatchesTemplateVisitor.matches(notA.getNegated(), notB.getNegated());
        }
        FilterPredicate predicateA = (FilterPredicate)a;
        FilterPredicate predicateB = (FilterPredicate)b;
        boolean valueMatches = predicateA.getValues().equals(predicateB.getValues());
        boolean usingTemplate = predicateA.getValues().stream().anyMatch(value -> TEMPLATE_PATTERN.matcher(value.toString()).matches());
        return predicateA.getPath().equals((Object)predicateB.getPath()) && predicateA.getOperator().equals((Object)predicateB.getOperator()) && (usingTemplate || valueMatches);
    }

    public static boolean isValid(FilterExpression templateFilter, FilterExpression clientFilter) {
        Preconditions.checkNotNull((Object)templateFilter);
        if (clientFilter == null) {
            return false;
        }
        FilterExpression normalizedTemplateFilter = (FilterExpression)templateFilter.accept((FilterExpressionVisitor)new FilterExpressionNormalizationVisitor());
        FilterExpression normalizedClientFilter = (FilterExpression)clientFilter.accept((FilterExpressionVisitor)new FilterExpressionNormalizationVisitor());
        return (Boolean)normalizedClientFilter.accept((FilterExpressionVisitor)new MatchesTemplateVisitor(normalizedTemplateFilter));
    }

    public MatchesTemplateVisitor(FilterExpression expressionToMatch) {
        this.expressionToMatch = expressionToMatch;
    }
}

