/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.metadata.models;

import com.yahoo.elide.annotation.Exclude;
import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.filter.dialect.ParseException;
import com.yahoo.elide.core.filter.dialect.RSQLFilterDialect;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.TypeHelper;
import com.yahoo.elide.datastores.aggregation.AggregationDataStore;
import com.yahoo.elide.datastores.aggregation.annotation.CardinalitySize;
import com.yahoo.elide.datastores.aggregation.annotation.TableMeta;
import com.yahoo.elide.datastores.aggregation.annotation.Temporal;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ValueType;
import com.yahoo.elide.datastores.aggregation.metadata.models.ArgumentDefinition;
import com.yahoo.elide.datastores.aggregation.metadata.models.Column;
import com.yahoo.elide.datastores.aggregation.metadata.models.Dimension;
import com.yahoo.elide.datastores.aggregation.metadata.models.Metric;
import com.yahoo.elide.datastores.aggregation.metadata.models.Namespace;
import com.yahoo.elide.datastores.aggregation.metadata.models.TimeDimension;
import com.yahoo.elide.datastores.aggregation.metadata.models.Versioned;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.annotation.FromSubquery;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.annotation.FromTable;
import com.yahoo.elide.modelconfig.model.Named;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.apache.commons.lang3.StringUtils;

@Include(name="table")
public abstract class Table
implements Versioned,
Named {
    @Id
    private final String id;
    private final String name;
    private final String friendlyName;
    private final String category;
    @Exclude
    private final String version;
    private final String description;
    private final CardinalitySize cardinality;
    private final String requiredFilter;
    private final boolean isFact;
    @ManyToOne
    private final Namespace namespace;
    @OneToMany
    private final Set<Column> columns;
    @OneToMany
    private final Set<Metric> metrics;
    @OneToMany
    private final Set<Dimension> dimensions;
    @OneToMany
    private final Set<TimeDimension> timeDimensions;
    private final Set<String> tags;
    @Exclude
    private final Set<String> hints;
    @Exclude
    private final Map<String, Column> columnMap;
    @Exclude
    private final String alias;
    @OneToMany
    private final Set<ArgumentDefinition> arguments;
    @Exclude
    private Type<?> model;

    public Set<ArgumentDefinition> getArgumentDefinitions() {
        return this.arguments;
    }

    public Table(Namespace namespace, Type<?> cls, EntityDictionary dictionary) {
        if (!dictionary.getBoundClasses().contains(cls)) {
            throw new IllegalArgumentException(String.format("Table class {%s} is not defined in dictionary.", cls));
        }
        this.namespace = namespace;
        namespace.addTable(this);
        this.name = dictionary.getJsonAliasFor(cls);
        this.version = EntityDictionary.getModelVersion(cls);
        this.model = cls;
        this.alias = TypeHelper.getTypeAlias(cls);
        this.id = this.name;
        TableMeta meta = (TableMeta)cls.getAnnotation(TableMeta.class);
        this.isFact = this.isFact(cls, meta);
        this.columns = this.constructColumns(cls, dictionary);
        this.columnMap = this.columns.stream().collect(Collectors.toMap(Column::getName, Function.identity()));
        this.metrics = this.columns.stream().filter(col -> col instanceof Metric).map(Metric.class::cast).collect(Collectors.toSet());
        this.dimensions = this.columns.stream().filter(col -> !(col instanceof Metric) && !(col instanceof TimeDimension)).map(Dimension.class::cast).collect(Collectors.toSet());
        this.timeDimensions = this.columns.stream().filter(col -> col instanceof TimeDimension).map(TimeDimension.class::cast).collect(Collectors.toSet());
        if (meta != null) {
            this.friendlyName = meta.friendlyName() != null && !meta.friendlyName().isEmpty() ? meta.friendlyName() : this.name;
            this.description = meta.description();
            this.category = meta.category();
            this.requiredFilter = meta.filterTemplate();
            this.tags = new HashSet<String>(Arrays.asList(meta.tags()));
            this.hints = new LinkedHashSet<String>(Arrays.asList(meta.hints()));
            this.cardinality = meta.size();
            this.arguments = meta.arguments().length == 0 ? new HashSet<ArgumentDefinition>() : (Set)Arrays.stream(meta.arguments()).map(argument -> new ArgumentDefinition(this.getId(), (com.yahoo.elide.datastores.aggregation.annotation.ArgumentDefinition)argument)).collect(Collectors.toCollection(LinkedHashSet::new));
        } else {
            this.friendlyName = this.name;
            this.description = null;
            this.category = null;
            this.requiredFilter = null;
            this.tags = new HashSet<String>();
            this.hints = new LinkedHashSet<String>();
            this.cardinality = CardinalitySize.UNKNOWN;
            this.arguments = new HashSet<ArgumentDefinition>();
        }
    }

    private boolean isFact(Type<?> cls, TableMeta meta) {
        if (meta != null) {
            return meta.isFact();
        }
        boolean existsAggAnnotations = cls.getAnnotation(FromTable.class) != null || cls.getAnnotation(FromSubquery.class) != null;
        return existsAggAnnotations;
    }

    private Set<Column> constructColumns(Type<?> cls, EntityDictionary dictionary) {
        Set<Column> columns = dictionary.getAllFields(cls).stream().filter(field -> {
            ValueType valueType = Column.getValueType(cls, field, dictionary);
            return valueType != ValueType.UNKNOWN;
        }).map(field -> {
            if (MetaDataStore.isMetricField(dictionary, cls, field)) {
                return this.constructMetric((String)field, dictionary);
            }
            if (dictionary.attributeOrRelationAnnotationExists(cls, field, Temporal.class)) {
                return this.constructTimeDimension((String)field, dictionary);
            }
            return this.constructDimension((String)field, dictionary);
        }).collect(Collectors.toSet());
        if (dictionary.getIdFieldName(cls) != null) {
            String idFieldName = dictionary.getIdFieldName(cls);
            if (AggregationDataStore.isAggregationStoreModel(cls)) {
                columns.add(this.constructMetric(idFieldName, dictionary));
            } else {
                columns.add(this.constructDimension(idFieldName, dictionary));
            }
        }
        return columns;
    }

    protected Metric constructMetric(String fieldName, EntityDictionary dictionary) {
        return new Metric(this, fieldName, dictionary);
    }

    protected TimeDimension constructTimeDimension(String fieldName, EntityDictionary dictionary) {
        return new TimeDimension(this, fieldName, dictionary);
    }

    protected Dimension constructDimension(String fieldName, EntityDictionary dictionary) {
        return new Dimension(this, fieldName, dictionary);
    }

    public <T extends ColumnProjection> Set<T> getColumns(Class<T> cls) {
        return this.columns.stream().filter(col -> cls.isAssignableFrom(col.getClass())).map(cls::cast).collect(Collectors.toSet());
    }

    public final <T extends Column> T getColumn(Class<T> cls, String fieldName) {
        Column column = this.columnMap.get(fieldName);
        return (T)(column != null && cls.isAssignableFrom(column.getClass()) ? (Column)cls.cast(column) : null);
    }

    public Metric getMetric(String fieldName) {
        return this.getColumn(Metric.class, fieldName);
    }

    public Dimension getDimension(String fieldName) {
        return this.getColumn(Dimension.class, fieldName);
    }

    public TimeDimension getTimeDimension(String fieldName) {
        return this.getColumn(TimeDimension.class, fieldName);
    }

    public boolean isMetric(String fieldName) {
        return this.getMetric(fieldName) != null;
    }

    public FilterExpression getRequiredFilter(EntityDictionary dictionary) {
        Type cls = dictionary.getEntityClass(this.name, this.version);
        RSQLFilterDialect filterDialect = new RSQLFilterDialect(dictionary);
        if (StringUtils.isNotEmpty((CharSequence)this.requiredFilter)) {
            try {
                return filterDialect.parseFilterExpression(this.requiredFilter, cls, false, true);
            }
            catch (ParseException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    public boolean hasArgumentDefinition(String argName) {
        return this.hasName(this.arguments, argName);
    }

    public ArgumentDefinition getArgumentDefinition(String argName) {
        return this.arguments.stream().filter(arg -> arg.getName().equals(argName)).findFirst().orElse(null);
    }

    public abstract Queryable toQueryable();

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getCategory() {
        return this.category;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public CardinalitySize getCardinality() {
        return this.cardinality;
    }

    public String getRequiredFilter() {
        return this.requiredFilter;
    }

    public boolean isFact() {
        return this.isFact;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Set<Column> getColumns() {
        return this.columns;
    }

    public Set<Metric> getMetrics() {
        return this.metrics;
    }

    public Set<Dimension> getDimensions() {
        return this.dimensions;
    }

    public Set<TimeDimension> getTimeDimensions() {
        return this.timeDimensions;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public Set<String> getHints() {
        return this.hints;
    }

    public Map<String, Column> getColumnMap() {
        return this.columnMap;
    }

    public String getAlias() {
        return this.alias;
    }

    public Type<?> getModel() {
        return this.model;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        Table other = (Table)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFact() != other.isFact()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$friendlyName = this.getFriendlyName();
        String other$friendlyName = other.getFriendlyName();
        if (this$friendlyName == null ? other$friendlyName != null : !this$friendlyName.equals(other$friendlyName)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        CardinalitySize this$cardinality = this.getCardinality();
        CardinalitySize other$cardinality = other.getCardinality();
        if (this$cardinality == null ? other$cardinality != null : !((Object)((Object)this$cardinality)).equals((Object)other$cardinality)) {
            return false;
        }
        String this$requiredFilter = this.getRequiredFilter();
        String other$requiredFilter = other.getRequiredFilter();
        if (this$requiredFilter == null ? other$requiredFilter != null : !this$requiredFilter.equals(other$requiredFilter)) {
            return false;
        }
        Namespace this$namespace = this.getNamespace();
        Namespace other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !((Object)this$namespace).equals(other$namespace)) {
            return false;
        }
        Set<Column> this$columns = this.getColumns();
        Set<Column> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        Set<Metric> this$metrics = this.getMetrics();
        Set<Metric> other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        Set<Dimension> this$dimensions = this.getDimensions();
        Set<Dimension> other$dimensions = other.getDimensions();
        if (this$dimensions == null ? other$dimensions != null : !((Object)this$dimensions).equals(other$dimensions)) {
            return false;
        }
        Set<TimeDimension> this$timeDimensions = this.getTimeDimensions();
        Set<TimeDimension> other$timeDimensions = other.getTimeDimensions();
        if (this$timeDimensions == null ? other$timeDimensions != null : !((Object)this$timeDimensions).equals(other$timeDimensions)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Set<String> this$hints = this.getHints();
        Set<String> other$hints = other.getHints();
        if (this$hints == null ? other$hints != null : !((Object)this$hints).equals(other$hints)) {
            return false;
        }
        Map<String, Column> this$columnMap = this.getColumnMap();
        Map<String, Column> other$columnMap = other.getColumnMap();
        if (this$columnMap == null ? other$columnMap != null : !((Object)this$columnMap).equals(other$columnMap)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        Set<ArgumentDefinition> this$arguments = this.arguments;
        Set<ArgumentDefinition> other$arguments = other.arguments;
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        Type<?> this$model = this.getModel();
        Type<?> other$model = other.getModel();
        return !(this$model == null ? other$model != null : !this$model.equals(other$model));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Table;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFact() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $friendlyName = this.getFriendlyName();
        result = result * 59 + ($friendlyName == null ? 43 : $friendlyName.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        CardinalitySize $cardinality = this.getCardinality();
        result = result * 59 + ($cardinality == null ? 43 : ((Object)((Object)$cardinality)).hashCode());
        String $requiredFilter = this.getRequiredFilter();
        result = result * 59 + ($requiredFilter == null ? 43 : $requiredFilter.hashCode());
        Namespace $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : ((Object)$namespace).hashCode());
        Set<Column> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        Set<Metric> $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        Set<Dimension> $dimensions = this.getDimensions();
        result = result * 59 + ($dimensions == null ? 43 : ((Object)$dimensions).hashCode());
        Set<TimeDimension> $timeDimensions = this.getTimeDimensions();
        result = result * 59 + ($timeDimensions == null ? 43 : ((Object)$timeDimensions).hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Set<String> $hints = this.getHints();
        result = result * 59 + ($hints == null ? 43 : ((Object)$hints).hashCode());
        Map<String, Column> $columnMap = this.getColumnMap();
        result = result * 59 + ($columnMap == null ? 43 : ((Object)$columnMap).hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        Set<ArgumentDefinition> $arguments = this.arguments;
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        Type<?> $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        return result;
    }

    public String toString() {
        return "Table(id=" + this.getId() + ", name=" + this.getName() + ", friendlyName=" + this.getFriendlyName() + ", category=" + this.getCategory() + ", version=" + this.getVersion() + ", description=" + this.getDescription() + ", cardinality=" + (Object)((Object)this.getCardinality()) + ", requiredFilter=" + this.getRequiredFilter() + ", isFact=" + this.isFact() + ", namespace=" + this.getNamespace() + ", alias=" + this.getAlias() + ", model=" + this.getModel() + ")";
    }
}

