/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.query;

import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ColumnType;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ValueType;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import java.io.Serializable;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public interface ColumnProjection
extends Serializable {
    default public String getAlias() {
        return this.getName();
    }

    default public String getSafeAlias() {
        String alias = this.getAlias();
        String name = this.getName();
        if (name.equals(alias)) {
            return name;
        }
        return ColumnProjection.createSafeAlias(name, alias);
    }

    public String getName();

    public String getExpression();

    public ValueType getValueType();

    public ColumnType getColumnType();

    default public Map<String, Argument> getArguments() {
        return Collections.emptyMap();
    }

    public boolean equals(Object var1);

    public int hashCode();

    public static String createSafeAlias(String name, String alias) {
        return name + "_" + (Base64.getEncoder().encodeToString(alias.getBytes()).hashCode() & 0xFFFFFFF);
    }

    default public boolean canNest(Queryable source, MetaDataStore metaDataStore) {
        return true;
    }

    public Pair<ColumnProjection, Set<ColumnProjection>> nest(Queryable var1, MetaDataStore var2, boolean var3);

    public <T extends ColumnProjection> T withProjected(boolean var1);

    public ColumnProjection withArguments(Map<String, Argument> var1);

    default public boolean isProjected() {
        return true;
    }
}

