/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql.expression;

import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.TypeHelper;
import com.yahoo.elide.datastores.aggregation.annotation.JoinType;
import com.yahoo.elide.datastores.aggregation.core.JoinPath;
import com.yahoo.elide.datastores.aggregation.metadata.ColumnContext;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.metadata.TableContext;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.dialects.SQLDialect;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.ColumnArgReference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.JoinReference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.LogicalReference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.PhysicalReference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.ReferenceVisitor;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.TableArgReference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.metadata.SQLJoin;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.metadata.SQLTable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class JoinExpressionExtractor
implements ReferenceVisitor<Set<String>> {
    private static final String ON = "ON ";
    private static final String OPEN_BRACKET = "(";
    private static final String CLOSE_BRACKET = ")";
    private final Set<String> joinExpressions = new LinkedHashSet<String>();
    private final ColumnContext context;
    private final MetaDataStore metaDataStore;
    private final EntityDictionary dictionary;

    public JoinExpressionExtractor(ColumnContext context) {
        this.context = context;
        this.metaDataStore = context.getMetaDataStore();
        this.dictionary = context.getMetaDataStore().getMetadataDictionary();
    }

    @Override
    public Set<String> visitPhysicalReference(PhysicalReference reference) {
        return this.joinExpressions;
    }

    @Override
    public Set<String> visitLogicalReference(LogicalReference reference) {
        ColumnProjection newColumn = reference.getColumn();
        ColumnContext newCtx = ColumnContext.builder().queryable(this.context.getQueryable()).alias(this.context.getAlias()).metaDataStore(this.context.getMetaDataStore()).column(newColumn).tableArguments(this.context.getTableArguments()).build();
        JoinExpressionExtractor visitor = new JoinExpressionExtractor(newCtx);
        reference.getReferences().forEach(ref -> this.joinExpressions.addAll((Collection<String>)ref.accept(visitor)));
        return this.joinExpressions;
    }

    @Override
    public Set<String> visitJoinReference(JoinReference reference) {
        JoinPath joinPath = reference.getPath();
        List pathElements = joinPath.getPathElements();
        ColumnContext currentCtx = this.context;
        for (int i = 0; i < pathElements.size() - 1; ++i) {
            String onClause;
            ColumnContext joinCtx;
            JoinType joinType;
            Path.PathElement pathElement = (Path.PathElement)pathElements.get(i);
            Type joinClass = pathElement.getFieldType();
            String joinFieldName = pathElement.getFieldName();
            SQLJoin sqlJoin = currentCtx.getQueryable().getJoin(joinFieldName);
            if (sqlJoin != null) {
                joinType = sqlJoin.getJoinType();
                joinCtx = (ColumnContext)currentCtx.get(joinFieldName);
                onClause = joinType.equals((Object)JoinType.CROSS) ? "" : ON + currentCtx.resolve(sqlJoin.getJoinExpression());
            } else {
                joinType = JoinType.LEFT;
                SQLTable table = (SQLTable)this.metaDataStore.getTable(joinClass);
                joinCtx = ColumnContext.builder().queryable(table).alias(TypeHelper.appendAlias((String)currentCtx.getAlias(), (String)joinFieldName)).metaDataStore(currentCtx.getMetaDataStore()).column(currentCtx.getColumn()).tableArguments(ColumnContext.mergedArgumentMap(table.getArguments(), currentCtx.getTableArguments())).build();
                onClause = ON + String.format("%s.%s = %s.%s", currentCtx.getAlias(), this.dictionary.getAnnotatedColumnName(pathElement.getType(), joinFieldName), joinCtx.getAlias(), this.dictionary.getAnnotatedColumnName(joinClass, this.dictionary.getIdFieldName(joinClass)));
            }
            SQLDialect sqlDialect = currentCtx.getQueryable().getDialect();
            String joinAlias = ColumnContext.applyQuotes(joinCtx.getAlias(), sqlDialect);
            String joinKeyword = currentCtx.getQueryable().getDialect().getJoinKeyword(joinType);
            String joinSource = this.constructTableOrSubselect(joinCtx, joinClass);
            String fullExpression = sqlDialect.useASBeforeTableAlias() ? String.format("%s %s AS %s %s", joinKeyword, joinSource, joinAlias, onClause) : String.format("%s %s %s %s", joinKeyword, joinSource, joinAlias, onClause);
            this.joinExpressions.add(fullExpression);
            currentCtx = joinCtx;
        }
        JoinExpressionExtractor visitor = new JoinExpressionExtractor(currentCtx);
        this.joinExpressions.addAll((Collection<String>)reference.getReference().accept(visitor));
        return this.joinExpressions;
    }

    private String constructTableOrSubselect(ColumnContext columnCtx, Type<?> cls) {
        if (SQLTable.hasSql(cls)) {
            TableContext context = TableContext.builder().tableArguments(columnCtx.getTableArguments()).build();
            String selectSql = context.resolve(SQLTable.resolveTableOrSubselect(this.dictionary, cls));
            return OPEN_BRACKET + selectSql + CLOSE_BRACKET;
        }
        return ColumnContext.applyQuotes(SQLTable.resolveTableOrSubselect(this.dictionary, cls), columnCtx.getQueryable().getDialect());
    }

    @Override
    public Set<String> visitColumnArgReference(ColumnArgReference reference) {
        return Collections.emptySet();
    }

    @Override
    public Set<String> visitTableArgReference(TableArgReference reference) {
        return Collections.emptySet();
    }
}

