/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql.query;

import com.yahoo.elide.core.exceptions.InvalidParameterizedAttributeException;
import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.datastores.aggregation.metadata.ColumnContext;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ColumnType;
import com.yahoo.elide.datastores.aggregation.metadata.enums.TimeGrain;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ValueType;
import com.yahoo.elide.datastores.aggregation.metadata.models.TimeDimension;
import com.yahoo.elide.datastores.aggregation.metadata.models.TimeDimensionGrain;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.query.TimeDimensionProjection;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.ExpressionParser;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.Reference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.SQLColumnProjection;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang3.tuple.Pair;

public final class SQLTimeDimensionProjection
implements SQLColumnProjection,
TimeDimensionProjection {
    private final String alias;
    private final String name;
    private final String expression;
    private final ValueType valueType;
    private final ColumnType columnType;
    private final TimeDimensionGrain grain;
    private final TimeZone timeZone;
    private final Map<String, Argument> arguments;
    private final boolean projected;

    public SQLTimeDimensionProjection(TimeDimension column, TimeZone timeZone, String alias, Map<String, Argument> arguments, boolean projected) {
        this.columnType = column.getColumnType();
        this.valueType = column.getValueType();
        this.expression = column.getExpression();
        this.name = column.getName();
        this.grain = this.getGrainFromArguments(arguments, column);
        this.arguments = arguments;
        this.alias = alias;
        this.timeZone = timeZone;
        this.projected = projected;
    }

    @Override
    public String toSQL(Queryable query, MetaDataStore metaDataStore) {
        ColumnContext context = ColumnContext.builder().queryable(query).alias(query.getSource().getAlias()).metaDataStore(metaDataStore).column(this).tableArguments(query.getArguments()).build();
        return context.resolve(this.grain.getExpression());
    }

    @Override
    public TimeGrain getGrain() {
        return this.grain.getGrain();
    }

    @Override
    public Pair<ColumnProjection, Set<ColumnProjection>> nest(Queryable source, MetaDataStore store, boolean joinInOuter) {
        Set<ColumnProjection> innerProjections;
        SQLTimeDimensionProjection outerProjection;
        boolean inProjection;
        List<Reference> references = new ExpressionParser(store).parse(source, this.getExpression());
        boolean requiresJoin = SQLColumnProjection.requiresJoin(references);
        boolean bl = inProjection = source.getColumnProjection(this.getName(), this.getArguments(), true) != null;
        if (requiresJoin && joinInOuter) {
            String outerProjectionExpression = this.toPhysicalReferences(source, store);
            outerProjection = this.withExpression(outerProjectionExpression, inProjection);
            innerProjections = SQLColumnProjection.extractPhysicalReferences(source, references, store);
        } else {
            outerProjection = SQLTimeDimensionProjection.builder().name(this.name).alias(this.alias).valueType(this.valueType).columnType(this.columnType).grain(new TimeDimensionGrain(this.getName(), this.grain.getGrain())).expression("{{$" + this.getSafeAlias() + "}}").projected(this.isProjected()).arguments(this.arguments).timeZone(this.timeZone).build();
            innerProjections = new LinkedHashSet<SQLTimeDimensionProjection>(Arrays.asList(this));
        }
        return Pair.of((Object)outerProjection, innerProjections);
    }

    public SQLTimeDimensionProjection withProjected(boolean projected) {
        return new SQLTimeDimensionProjection(this.alias, this.name, this.expression, this.valueType, this.columnType, this.grain, this.timeZone, this.arguments, projected);
    }

    public SQLTimeDimensionProjection withExpression(String expression, boolean projected) {
        return new SQLTimeDimensionProjection(this.alias, this.name, expression, this.valueType, this.columnType, this.grain, this.timeZone, this.arguments, projected);
    }

    private TimeDimensionGrain getGrainFromArguments(Map<String, Argument> arguments, TimeDimension column) {
        Argument grainArgument = arguments.get("grain");
        if (grainArgument == null) {
            return column.getDefaultGrain();
        }
        String grainName = grainArgument.getValue().toString().toLowerCase(Locale.ENGLISH);
        return column.getSupportedGrains().stream().filter(grain -> grain.getGrain().name().toLowerCase(Locale.ENGLISH).equals(grainName)).findFirst().orElseThrow(() -> new InvalidParameterizedAttributeException(this.name, grainArgument));
    }

    @Override
    public boolean isProjected() {
        return this.projected;
    }

    @Override
    public ColumnProjection withArguments(Map<String, Argument> arguments) {
        return new SQLTimeDimensionProjection(this.alias, this.name, this.expression, this.valueType, this.columnType, this.grain, this.timeZone, arguments, this.projected);
    }

    public static SQLTimeDimensionProjectionBuilder builder() {
        return new SQLTimeDimensionProjectionBuilder();
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public ColumnType getColumnType() {
        return this.columnType;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public Map<String, Argument> getArguments() {
        return this.arguments;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SQLTimeDimensionProjection)) {
            return false;
        }
        SQLTimeDimensionProjection other = (SQLTimeDimensionProjection)o;
        if (this.isProjected() != other.isProjected()) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        ValueType this$valueType = this.getValueType();
        ValueType other$valueType = other.getValueType();
        if (this$valueType == null ? other$valueType != null : !((Object)((Object)this$valueType)).equals((Object)other$valueType)) {
            return false;
        }
        ColumnType this$columnType = this.getColumnType();
        ColumnType other$columnType = other.getColumnType();
        if (this$columnType == null ? other$columnType != null : !((Object)((Object)this$columnType)).equals((Object)other$columnType)) {
            return false;
        }
        TimeGrain this$grain = this.getGrain();
        TimeGrain other$grain = other.getGrain();
        if (this$grain == null ? other$grain != null : !((Object)((Object)this$grain)).equals((Object)other$grain)) {
            return false;
        }
        TimeZone this$timeZone = this.getTimeZone();
        TimeZone other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        Map<String, Argument> this$arguments = this.getArguments();
        Map<String, Argument> other$arguments = other.getArguments();
        return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isProjected() ? 79 : 97);
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        ValueType $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 43 : ((Object)((Object)$valueType)).hashCode());
        ColumnType $columnType = this.getColumnType();
        result = result * 59 + ($columnType == null ? 43 : ((Object)((Object)$columnType)).hashCode());
        TimeGrain $grain = this.getGrain();
        result = result * 59 + ($grain == null ? 43 : ((Object)((Object)$grain)).hashCode());
        TimeZone $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        Map<String, Argument> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        return result;
    }

    public String toString() {
        return "SQLTimeDimensionProjection(alias=" + this.getAlias() + ", name=" + this.getName() + ", expression=" + this.getExpression() + ", valueType=" + (Object)((Object)this.getValueType()) + ", columnType=" + (Object)((Object)this.getColumnType()) + ", grain=" + (Object)((Object)this.getGrain()) + ", timeZone=" + this.getTimeZone() + ", arguments=" + this.getArguments() + ", projected=" + this.isProjected() + ")";
    }

    public SQLTimeDimensionProjection(String alias, String name, String expression, ValueType valueType, ColumnType columnType, TimeDimensionGrain grain, TimeZone timeZone, Map<String, Argument> arguments, boolean projected) {
        this.alias = alias;
        this.name = name;
        this.expression = expression;
        this.valueType = valueType;
        this.columnType = columnType;
        this.grain = grain;
        this.timeZone = timeZone;
        this.arguments = arguments;
        this.projected = projected;
    }

    public static class SQLTimeDimensionProjectionBuilder {
        private String alias;
        private String name;
        private String expression;
        private ValueType valueType;
        private ColumnType columnType;
        private TimeDimensionGrain grain;
        private TimeZone timeZone;
        private Map<String, Argument> arguments;
        private boolean projected;

        SQLTimeDimensionProjectionBuilder() {
        }

        public SQLTimeDimensionProjectionBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public SQLTimeDimensionProjectionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SQLTimeDimensionProjectionBuilder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public SQLTimeDimensionProjectionBuilder valueType(ValueType valueType) {
            this.valueType = valueType;
            return this;
        }

        public SQLTimeDimensionProjectionBuilder columnType(ColumnType columnType) {
            this.columnType = columnType;
            return this;
        }

        public SQLTimeDimensionProjectionBuilder grain(TimeDimensionGrain grain) {
            this.grain = grain;
            return this;
        }

        public SQLTimeDimensionProjectionBuilder timeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public SQLTimeDimensionProjectionBuilder arguments(Map<String, Argument> arguments) {
            this.arguments = arguments;
            return this;
        }

        public SQLTimeDimensionProjectionBuilder projected(boolean projected) {
            this.projected = projected;
            return this;
        }

        public SQLTimeDimensionProjection build() {
            return new SQLTimeDimensionProjection(this.alias, this.name, this.expression, this.valueType, this.columnType, this.grain, this.timeZone, this.arguments, this.projected);
        }

        public String toString() {
            return "SQLTimeDimensionProjection.SQLTimeDimensionProjectionBuilder(alias=" + this.alias + ", name=" + this.name + ", expression=" + this.expression + ", valueType=" + (Object)((Object)this.valueType) + ", columnType=" + (Object)((Object)this.columnType) + ", grain=" + this.grain + ", timeZone=" + this.timeZone + ", arguments=" + this.arguments + ", projected=" + this.projected + ")";
        }
    }
}

