/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.timegrains;

import com.yahoo.elide.core.utils.coerce.converters.ElideTypeConverter;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import com.yahoo.elide.datastores.aggregation.metadata.enums.TimeGrain;
import com.yahoo.elide.datastores.aggregation.timegrains.Time;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class Minute
extends Time {
    public static final String FORMAT = "yyyy-MM-dd'T'HH:mm";
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm").withZone(ZoneOffset.systemDefault());

    public Minute(Date date) {
        super(date, true, true, true, true, true, false, Minute.getSerializer(TimeGrain.MINUTE));
    }

    public Minute(LocalDateTime date) {
        super(date, true, true, true, true, true, false, Minute.getSerializer(TimeGrain.MINUTE));
    }

    @ElideTypeConverter(type=Minute.class, name="Minute")
    public static class MinuteSerde
    implements Serde<Object, Minute> {
        public Minute deserialize(Object val) {
            if (val instanceof Date) {
                return new Minute((Date)val);
            }
            return new Minute(LocalDateTime.parse(val.toString(), FORMATTER));
        }

        public String serialize(Minute val) {
            return val.serializer.format(val);
        }
    }
}

