/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.timegrains;

import com.yahoo.elide.core.utils.coerce.converters.ElideTypeConverter;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import com.yahoo.elide.datastores.aggregation.metadata.enums.TimeGrain;
import com.yahoo.elide.datastores.aggregation.timegrains.Time;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class Month
extends Time {
    public static final String FORMAT = "yyyy-MM";
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM").withZone(ZoneOffset.systemDefault());

    public Month(Date date) {
        super(date, true, true, false, false, false, false, Month.getSerializer(TimeGrain.MONTH));
    }

    public Month(LocalDateTime date) {
        super(date, true, true, false, false, false, false, Month.getSerializer(TimeGrain.MONTH));
    }

    @ElideTypeConverter(type=Month.class, name="Month")
    public static class MonthSerde
    implements Serde<Object, Month> {
        public Month deserialize(Object val) {
            if (val instanceof Date) {
                return new Month((Date)val);
            }
            YearMonth yearMonth = YearMonth.parse(val.toString(), FORMATTER);
            LocalDateTime localDateTime = LocalDateTime.of(yearMonth.getYear(), yearMonth.getMonth(), 1, 0, 0);
            return new Month(localDateTime);
        }

        public String serialize(Month val) {
            return val.serializer.format(val);
        }
    }
}

