/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.timegrains;

import com.yahoo.elide.core.utils.coerce.converters.ElideTypeConverter;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import com.yahoo.elide.datastores.aggregation.metadata.enums.TimeGrain;
import com.yahoo.elide.datastores.aggregation.timegrains.Time;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class Quarter
extends Time {
    public static final String FORMAT = "yyyy-MM";
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM").withZone(ZoneId.systemDefault());

    public Quarter(LocalDateTime date) {
        super(date, true, true, false, false, false, false, Quarter.getSerializer(TimeGrain.QUARTER));
    }

    @ElideTypeConverter(type=Quarter.class, name="Quarter")
    public static class QuarterSerde
    implements Serde<Object, Quarter> {
        public Quarter deserialize(Object val) {
            LocalDateTime date;
            if (val instanceof Date) {
                date = LocalDateTime.ofInstant(((Date)val).toInstant(), ZoneOffset.systemDefault());
            } else {
                YearMonth yearMonth = YearMonth.parse(val.toString(), FORMATTER);
                date = LocalDateTime.of(yearMonth.getYear(), yearMonth.getMonth(), 1, 0, 0);
            }
            int month = date.getMonthValue();
            if (month != 1 && month != 4 && month != 7 && month != 10) {
                throw new IllegalArgumentException("Date string not a quarter month");
            }
            return new Quarter(date);
        }

        public String serialize(Quarter val) {
            return val.serializer.format(val);
        }
    }
}

