/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.validator;

import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.metadata.models.Column;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.ColumnArgReference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.ExpressionParser;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.LogicalReference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.Reference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.ReferenceExtractor;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.metadata.SQLTable;
import com.yahoo.elide.datastores.aggregation.validator.TableArgumentValidator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ColumnArgumentValidator {
    private final MetaDataStore metaDataStore;
    private final SQLTable table;
    private final Column column;
    private final String errorMsgPrefix;
    private final ExpressionParser parser;

    public ColumnArgumentValidator(MetaDataStore metaDataStore, SQLTable table, Column column) {
        this.metaDataStore = metaDataStore;
        this.table = table;
        this.column = column;
        this.errorMsgPrefix = String.format("Failed to verify column arguments for column: %s in table: %s. ", column.getName(), table.getName());
        this.parser = new ExpressionParser(metaDataStore);
    }

    public void validate() {
        this.column.getArgumentDefinitions().forEach(arg -> {
            TableArgumentValidator.verifyValues(arg, this.errorMsgPrefix);
            TableArgumentValidator.verifyDefaultValue(arg, this.errorMsgPrefix);
        });
        List<Reference> references = this.parser.parse((Queryable)this.table, this.column.getExpression());
        ReferenceExtractor<LogicalReference> logicalRefExtractor = new ReferenceExtractor<LogicalReference>(LogicalReference.class, this.metaDataStore, ReferenceExtractor.Mode.SAME_COLUMN);
        ReferenceExtractor<ColumnArgReference> columnArgRefExtractor = new ReferenceExtractor<ColumnArgReference>(ColumnArgReference.class, this.metaDataStore, ReferenceExtractor.Mode.SAME_COLUMN);
        references.stream().map(reference -> (Set)reference.accept(columnArgRefExtractor)).flatMap(Collection::stream).map(ColumnArgReference::getArgName).forEach(argName -> {
            if (!this.column.hasArgumentDefinition((String)argName)) {
                throw new IllegalStateException(String.format(this.errorMsgPrefix + "Argument '%s' is not defined but found '{{$$column.args.%s}}'.", argName, argName));
            }
        });
        references.stream().map(reference -> (Set)reference.accept(logicalRefExtractor)).flatMap(Collection::stream).forEach(this::verifyLogicalReference);
    }

    private void verifyLogicalReference(LogicalReference reference) {
        SQLTable sqlTable = (SQLTable)reference.getSource();
        ColumnProjection columnProj = reference.getColumn();
        Map<String, Argument> mergedArguments = columnProj.getArguments();
        Column refColumn = sqlTable.getColumn(Column.class, columnProj.getName());
        this.verifyPinnedArguments(mergedArguments, refColumn, String.format(this.errorMsgPrefix + "Type mismatch of Fixed value provided for Dependent Column: '%s' in table: '%s'. ", refColumn.getName(), sqlTable.getName()));
        refColumn.getArgumentDefinitions().forEach(argDef -> {
            String argName = argDef.getName();
            if (this.column.hasArgumentDefinition(argName)) {
                if (argDef.getType() != this.column.getArgumentDefinition(argName).getType()) {
                    throw new IllegalStateException(String.format(this.errorMsgPrefix + "Argument type mismatch. Dependent Column: '%s' in table: '%s' has same Argument: '%s' with type '%s'.", new Object[]{refColumn.getName(), sqlTable.getName(), argName, argDef.getType()}));
                }
            } else if (StringUtils.isBlank((CharSequence)argDef.getDefaultValue().toString()) && StringUtils.isBlank((CharSequence)((Argument)mergedArguments.get(argName)).getValue().toString())) {
                throw new IllegalStateException(String.format(this.errorMsgPrefix + "Argument '%s' with type '%s' is not defined but is required for Dependent Column: '%s' in table: '%s'.", new Object[]{argName, argDef.getType(), refColumn.getName(), sqlTable.getName()}));
            }
        });
    }

    private void verifyPinnedArguments(Map<String, Argument> mergedArguments, Column refColumn, String errorMsgPrefix) {
        mergedArguments.forEach((argName, arg) -> {
            Object originalValue = refColumn.getArgumentDefinition((String)argName).getDefaultValue();
            if (!arg.getValue().equals(originalValue)) {
                TableArgumentValidator.verifyValue(refColumn.getArgumentDefinition((String)argName), arg.getValue().toString(), errorMsgPrefix + "Pinned ");
            }
        });
    }
}

