/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation;

import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.InvalidOperationException;
import com.yahoo.elide.core.filter.Operator;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.PredicateExtractionVisitor;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.core.request.Sorting;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.datastores.aggregation.QueryValidator;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ValueType;
import com.yahoo.elide.datastores.aggregation.metadata.models.ArgumentDefinition;
import com.yahoo.elide.datastores.aggregation.metadata.models.Column;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.Query;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.metadata.SQLTable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultQueryValidator
implements QueryValidator {
    private static final Set<Operator> REGEX_OPERATORS = Stream.of(Operator.INFIX, Operator.INFIX_CASE_INSENSITIVE, Operator.POSTFIX, Operator.POSTFIX_CASE_INSENSITIVE, Operator.PREFIX, Operator.PREFIX_CASE_INSENSITIVE).collect(Collectors.toCollection(HashSet::new));
    protected EntityDictionary dictionary;

    public DefaultQueryValidator(EntityDictionary dictionary) {
        this.dictionary = dictionary;
    }

    @Override
    public void validateHavingClause(Query query) {
        FilterExpression havingClause = query.getHavingFilter();
        if (havingClause == null) {
            return;
        }
        ((Collection)havingClause.accept((FilterExpressionVisitor)new PredicateExtractionVisitor())).forEach(predicate -> {
            Path path = predicate.getPath();
            if (path.getPathElements().size() > 1) {
                throw new InvalidOperationException("Relationship traversal not supported for analytic queries.");
            }
            this.validatePredicate(query, (FilterPredicate)predicate);
            Queryable.extractFilterProjections(query, havingClause).stream().forEach(projection -> {
                if (query.getColumnProjection(projection.getAlias(), projection.getArguments()) == null) {
                    if (query.getColumnProjection(projection.getAlias()) == null) {
                        throw new InvalidOperationException(String.format("Post aggregation filtering on '%s' requires the field to be projected in the response", projection.getAlias()));
                    }
                    throw new InvalidOperationException(String.format("Post aggregation filtering on '%s' requires the field to be projected in the response with matching arguments", projection.getAlias()));
                }
            });
        });
    }

    @Override
    public void validateWhereClause(Query query) {
        FilterExpression whereClause = query.getWhereFilter();
        if (whereClause == null) {
            return;
        }
        ((Collection)whereClause.accept((FilterExpressionVisitor)new PredicateExtractionVisitor())).forEach(predicate -> {
            Path path = predicate.getPath();
            if (path.getPathElements().size() > 1) {
                throw new InvalidOperationException("Relationship traversal not supported for analytic queries.");
            }
            this.validatePredicate(query, (FilterPredicate)predicate);
        });
    }

    protected void validatePredicate(Query query, FilterPredicate predicate) {
        SQLTable table = (SQLTable)query.getSource();
        Set<ColumnProjection> projections = Queryable.extractFilterProjections(query, (FilterExpression)predicate);
        if (projections.isEmpty()) {
            return;
        }
        ColumnProjection projection = projections.iterator().next();
        this.validateColumn(query, projection);
        Column column = table.getColumn(Column.class, projection.getName());
        if (column.getValueType().equals((Object)ValueType.ID)) {
            throw new InvalidOperationException("Filtering by ID is not supported on " + query.getSource().getName());
        }
        if (column.getValues() == null || column.getValues().isEmpty()) {
            return;
        }
        if (REGEX_OPERATORS.contains(predicate.getOperator())) {
            return;
        }
        predicate.getValues().forEach(value -> {
            if (!column.getValues().contains(value)) {
                throw new InvalidOperationException(String.format("Column '%s' values must match one of these values: %s", projection.getAlias(), column.getValues()));
            }
        });
    }

    @Override
    public void validateSorting(Query query) {
        Sorting sorting = query.getSorting();
        if (sorting == null) {
            return;
        }
        Map sortClauses = sorting.getSortingPaths();
        Set allFields = query.getColumnProjections().stream().map(ColumnProjection::getAlias).collect(Collectors.toCollection(LinkedHashSet::new));
        sortClauses.keySet().forEach(path -> this.validateSortingPath((Path)path, allFields));
    }

    protected void validateSortingPath(Path path, Set<String> allFields) {
        List pathElements = path.getPathElements();
        if (pathElements.size() > 1) {
            throw new InvalidOperationException("Relationship traversal not supported for analytic queries.");
        }
        Path.PathElement currentElement = (Path.PathElement)pathElements.get(0);
        String currentField = currentElement.getAlias();
        Type currentClass = currentElement.getType();
        if (allFields.stream().noneMatch(currentField::equals)) {
            throw new InvalidOperationException("Can not sort on " + currentField + " as it is not present in query");
        }
        if (this.dictionary.getIdFieldName(currentClass).equals(currentField) || currentField.equals("id")) {
            throw new InvalidOperationException("Sorting on id field is not permitted");
        }
    }

    @Override
    public void validateProjectedColumns(Query query) {
        boolean onlyId = query.getColumnProjections().stream().allMatch(column -> column.getValueType().equals((Object)ValueType.ID));
        if (onlyId) {
            throw new InvalidOperationException("Cannot query a table only by ID");
        }
        query.getColumnProjections().forEach(column -> this.validateColumn(query, (ColumnProjection)column));
    }

    @Override
    public void validateQueryArguments(Query query) {
        SQLTable table = (SQLTable)query.getSource();
        table.getArgumentDefinitions().forEach(tableArgument -> {
            Argument clientArgument = query.getArguments().get(tableArgument.getName());
            this.validateArgument(Optional.ofNullable(clientArgument), (ArgumentDefinition)tableArgument, "table '" + query.getSource().getName() + "'");
        });
    }

    protected void validateColumn(Query query, ColumnProjection projection) {
        this.validateColumnArguments(query, projection);
    }

    protected void validateColumnArguments(Query query, ColumnProjection projection) {
        SQLTable table = (SQLTable)query.getSource();
        Column column = table.getColumn(Column.class, projection.getName());
        column.getArgumentDefinitions().forEach(columnArgument -> {
            Argument clientArgument = projection.getArguments().get(columnArgument.getName());
            this.validateArgument(Optional.ofNullable(clientArgument), (ArgumentDefinition)columnArgument, "column '" + projection.getAlias() + "'");
        });
    }

    protected void validateArgument(Optional<Argument> clientArgument, ArgumentDefinition argumentDefinition, String context) {
        if (!clientArgument.isPresent()) {
            if (argumentDefinition.isRequired()) {
                throw new InvalidOperationException(String.format("Argument '%s' for %s is required", argumentDefinition.getName(), context));
            }
            return;
        }
        if (argumentDefinition.getValues() != null && !argumentDefinition.getValues().isEmpty() && !argumentDefinition.getValues().contains(clientArgument.get().getValue().toString())) {
            throw new InvalidOperationException(String.format("Argument '%s' for %s must match one of these values: %s", argumentDefinition.getName(), context, argumentDefinition.getValues()));
        }
        Object clientArgumentValue = clientArgument.get().getValue();
        boolean isValid = argumentDefinition.getType().matches(clientArgumentValue.toString());
        if (!isValid) {
            throw new InvalidOperationException(String.format("Argument '%s' for %s has an invalid value: %s", argumentDefinition.getName(), context, clientArgumentValue));
        }
    }
}

