/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.metadata.models;

import com.yahoo.elide.annotation.Exclude;
import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.annotation.ToOne;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.datastores.aggregation.annotation.CardinalitySize;
import com.yahoo.elide.datastores.aggregation.annotation.ColumnMeta;
import com.yahoo.elide.datastores.aggregation.annotation.DimensionFormula;
import com.yahoo.elide.datastores.aggregation.annotation.MetricFormula;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ColumnType;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ValueSourceType;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ValueType;
import com.yahoo.elide.datastores.aggregation.metadata.models.ArgumentDefinition;
import com.yahoo.elide.datastores.aggregation.metadata.models.RequiresFilter;
import com.yahoo.elide.datastores.aggregation.metadata.models.Table;
import com.yahoo.elide.datastores.aggregation.metadata.models.TableSource;
import com.yahoo.elide.datastores.aggregation.metadata.models.Versioned;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.modelconfig.model.Named;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

@Include(rootLevel=false, name="column")
public abstract class Column
implements Versioned,
Named,
RequiresFilter {
    @Id
    private final String id;
    private final String name;
    private final String friendlyName;
    private final String category;
    private final String description;
    private final CardinalitySize cardinality;
    private final boolean hidden;
    @ToOne
    private final Table table;
    private final ValueType valueType;
    private final ColumnType columnType;
    private final String expression;
    private final ValueSourceType valueSourceType;
    private final Set<String> values;
    private String requiredFilter;
    @OneToOne
    private TableSource tableSource = null;
    @Exclude
    private com.yahoo.elide.datastores.aggregation.annotation.TableSource tableSourceDefinition;
    @OneToMany
    private final Set<ArgumentDefinition> arguments;
    private final Set<String> tags;

    public Set<ArgumentDefinition> getArgumentDefinitions() {
        return this.arguments;
    }

    protected Column(Table table, String fieldName, EntityDictionary dictionary) {
        this.table = table;
        Type tableClass = dictionary.getEntityClass(table.getName(), table.getVersion());
        this.id = Column.constructColumnName(tableClass, fieldName, dictionary);
        this.name = fieldName;
        String idField = dictionary.getIdFieldName(tableClass);
        this.hidden = idField != null && idField.equals(fieldName) ? false : !dictionary.getAllExposedFields(tableClass).contains(fieldName);
        ColumnMeta meta = (ColumnMeta)dictionary.getAttributeOrRelationAnnotation(tableClass, ColumnMeta.class, fieldName);
        if (meta != null) {
            this.friendlyName = meta.friendlyName() != null && !meta.friendlyName().isEmpty() ? meta.friendlyName() : this.name;
            this.description = meta.description();
            this.category = meta.category();
            this.values = new LinkedHashSet<String>(Arrays.asList(meta.values()));
            this.tags = new LinkedHashSet<String>(Arrays.asList(meta.tags()));
            this.tableSourceDefinition = meta.tableSource();
            this.valueSourceType = ValueSourceType.getValueSourceType(this.values, this.tableSourceDefinition);
            this.cardinality = meta.size();
            this.requiredFilter = meta.filterTemplate();
        } else {
            this.friendlyName = this.name;
            this.description = null;
            this.category = null;
            this.values = null;
            this.tags = new LinkedHashSet<String>();
            this.tableSourceDefinition = null;
            this.valueSourceType = ValueSourceType.NONE;
            this.cardinality = CardinalitySize.UNKNOWN;
            this.requiredFilter = null;
        }
        if (dictionary.attributeOrRelationAnnotationExists(tableClass, fieldName, MetricFormula.class)) {
            this.columnType = ColumnType.FORMULA;
            MetricFormula metricFormula = (MetricFormula)dictionary.getAttributeOrRelationAnnotation(tableClass, MetricFormula.class, fieldName);
            this.expression = metricFormula.value();
            this.arguments = Arrays.stream(metricFormula.arguments()).map(argument -> new ArgumentDefinition(this.getId(), (com.yahoo.elide.datastores.aggregation.annotation.ArgumentDefinition)argument)).collect(Collectors.toCollection(LinkedHashSet::new));
        } else if (dictionary.attributeOrRelationAnnotationExists(tableClass, fieldName, DimensionFormula.class)) {
            this.columnType = ColumnType.FORMULA;
            DimensionFormula dimensionFormula = (DimensionFormula)dictionary.getAttributeOrRelationAnnotation(tableClass, DimensionFormula.class, fieldName);
            this.expression = dimensionFormula.value();
            this.arguments = Arrays.stream(dimensionFormula.arguments()).map(argument -> new ArgumentDefinition(this.getId(), (com.yahoo.elide.datastores.aggregation.annotation.ArgumentDefinition)argument)).collect(Collectors.toCollection(LinkedHashSet::new));
        } else {
            this.columnType = ColumnType.FIELD;
            this.expression = "{{$" + dictionary.getAnnotatedColumnName(tableClass, fieldName) + "}}";
            this.arguments = new LinkedHashSet<ArgumentDefinition>();
        }
        this.valueType = Column.getValueType(tableClass, fieldName, dictionary);
        if (this.valueType == ValueType.UNKNOWN) {
            throw new IllegalArgumentException("Unknown data type for " + this.id);
        }
    }

    protected static String constructColumnName(Type<?> tableClass, String fieldName, EntityDictionary dictionary) {
        return dictionary.getJsonAliasFor(tableClass) + "." + fieldName;
    }

    public static ValueType getValueType(Type<?> tableClass, String fieldName, EntityDictionary dictionary) {
        if (dictionary.isRelation(tableClass, fieldName)) {
            return ValueType.UNKNOWN;
        }
        Type fieldClass = dictionary.getType(tableClass, fieldName);
        if (fieldName.equals(dictionary.getIdFieldName(tableClass))) {
            return ValueType.ID;
        }
        if (ClassType.DATE_TYPE.isAssignableFrom(fieldClass)) {
            return ValueType.TIME;
        }
        if (fieldClass.isEnum()) {
            return ValueType.TEXT;
        }
        return ValueType.getScalarType(fieldClass);
    }

    public ColumnProjection toProjection() {
        return this.table.toQueryable().getColumnProjection(this.getName());
    }

    @Override
    public String getVersion() {
        return this.table.getVersion();
    }

    public boolean hasArgumentDefinition(String argName) {
        return this.hasName(this.arguments, argName);
    }

    public ArgumentDefinition getArgumentDefinition(String argName) {
        return this.arguments.stream().filter(arg -> arg.getName().equals(argName)).findFirst().orElse(null);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public CardinalitySize getCardinality() {
        return this.cardinality;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public ColumnType getColumnType() {
        return this.columnType;
    }

    public String getExpression() {
        return this.expression;
    }

    public ValueSourceType getValueSourceType() {
        return this.valueSourceType;
    }

    public Set<String> getValues() {
        return this.values;
    }

    @Override
    public String getRequiredFilter() {
        return this.requiredFilter;
    }

    public TableSource getTableSource() {
        return this.tableSource;
    }

    public com.yahoo.elide.datastores.aggregation.annotation.TableSource getTableSourceDefinition() {
        return this.tableSourceDefinition;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column other = (Column)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHidden() != other.isHidden()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$friendlyName = this.getFriendlyName();
        String other$friendlyName = other.getFriendlyName();
        if (this$friendlyName == null ? other$friendlyName != null : !this$friendlyName.equals(other$friendlyName)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        CardinalitySize this$cardinality = this.getCardinality();
        CardinalitySize other$cardinality = other.getCardinality();
        if (this$cardinality == null ? other$cardinality != null : !((Object)((Object)this$cardinality)).equals((Object)other$cardinality)) {
            return false;
        }
        ValueType this$valueType = this.getValueType();
        ValueType other$valueType = other.getValueType();
        if (this$valueType == null ? other$valueType != null : !((Object)((Object)this$valueType)).equals((Object)other$valueType)) {
            return false;
        }
        ColumnType this$columnType = this.getColumnType();
        ColumnType other$columnType = other.getColumnType();
        if (this$columnType == null ? other$columnType != null : !((Object)((Object)this$columnType)).equals((Object)other$columnType)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        ValueSourceType this$valueSourceType = this.getValueSourceType();
        ValueSourceType other$valueSourceType = other.getValueSourceType();
        if (this$valueSourceType == null ? other$valueSourceType != null : !((Object)((Object)this$valueSourceType)).equals((Object)other$valueSourceType)) {
            return false;
        }
        Set<String> this$values = this.getValues();
        Set<String> other$values = other.getValues();
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        String this$requiredFilter = this.getRequiredFilter();
        String other$requiredFilter = other.getRequiredFilter();
        if (this$requiredFilter == null ? other$requiredFilter != null : !this$requiredFilter.equals(other$requiredFilter)) {
            return false;
        }
        TableSource this$tableSource = this.getTableSource();
        TableSource other$tableSource = other.getTableSource();
        if (this$tableSource == null ? other$tableSource != null : !((Object)this$tableSource).equals(other$tableSource)) {
            return false;
        }
        com.yahoo.elide.datastores.aggregation.annotation.TableSource this$tableSourceDefinition = this.getTableSourceDefinition();
        com.yahoo.elide.datastores.aggregation.annotation.TableSource other$tableSourceDefinition = other.getTableSourceDefinition();
        if (this$tableSourceDefinition == null ? other$tableSourceDefinition != null : !this$tableSourceDefinition.equals(other$tableSourceDefinition)) {
            return false;
        }
        Set<ArgumentDefinition> this$arguments = this.arguments;
        Set<ArgumentDefinition> other$arguments = other.arguments;
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Column;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHidden() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $friendlyName = this.getFriendlyName();
        result = result * 59 + ($friendlyName == null ? 43 : $friendlyName.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        CardinalitySize $cardinality = this.getCardinality();
        result = result * 59 + ($cardinality == null ? 43 : ((Object)((Object)$cardinality)).hashCode());
        ValueType $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 43 : ((Object)((Object)$valueType)).hashCode());
        ColumnType $columnType = this.getColumnType();
        result = result * 59 + ($columnType == null ? 43 : ((Object)((Object)$columnType)).hashCode());
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        ValueSourceType $valueSourceType = this.getValueSourceType();
        result = result * 59 + ($valueSourceType == null ? 43 : ((Object)((Object)$valueSourceType)).hashCode());
        Set<String> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        String $requiredFilter = this.getRequiredFilter();
        result = result * 59 + ($requiredFilter == null ? 43 : $requiredFilter.hashCode());
        TableSource $tableSource = this.getTableSource();
        result = result * 59 + ($tableSource == null ? 43 : ((Object)$tableSource).hashCode());
        com.yahoo.elide.datastores.aggregation.annotation.TableSource $tableSourceDefinition = this.getTableSourceDefinition();
        result = result * 59 + ($tableSourceDefinition == null ? 43 : $tableSourceDefinition.hashCode());
        Set<ArgumentDefinition> $arguments = this.arguments;
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "Column(id=" + this.getId() + ", name=" + this.getName() + ", friendlyName=" + this.getFriendlyName() + ", category=" + this.getCategory() + ", description=" + this.getDescription() + ", cardinality=" + this.getCardinality() + ", hidden=" + this.isHidden() + ", valueType=" + this.getValueType() + ", columnType=" + this.getColumnType() + ", expression=" + this.getExpression() + ", valueSourceType=" + this.getValueSourceType() + ", values=" + this.getValues() + ", requiredFilter=" + this.getRequiredFilter() + ", tableSource=" + this.getTableSource() + ", tableSourceDefinition=" + this.getTableSourceDefinition() + ")";
    }

    public void setTableSource(TableSource tableSource) {
        this.tableSource = tableSource;
    }
}

