/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.dynamic;

import com.yahoo.elide.annotation.ApiVersion;
import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.core.type.Package;
import com.yahoo.elide.modelconfig.model.NamespaceConfig;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

public class NamespacePackage
implements Package {
    private static final long serialVersionUID = -7173317858416763972L;
    public static final String EMPTY = "";
    public static final String DEFAULT = "default";
    public static NamespacePackage DEFAULT_NAMESPACE = new NamespacePackage("", "Default Namespace", "default", "");
    protected NamespaceConfig namespace;
    private transient Map<Class<? extends Annotation>, Annotation> annotations;

    public NamespacePackage(NamespaceConfig namespace) {
        this.namespace = namespace.getName().equals(DEFAULT) ? NamespaceConfig.builder().name(EMPTY).friendlyName(namespace.getFriendlyName()).description(namespace.getDescription()).apiVersion(namespace.getApiVersion()).build() : namespace;
        this.annotations = NamespacePackage.buildAnnotations(this.namespace);
    }

    public NamespacePackage(String name, String description, String friendlyName, String version) {
        this(NamespaceConfig.builder().name(name).friendlyName(friendlyName).description(description).apiVersion(version).build());
    }

    public <A extends Annotation> A getDeclaredAnnotation(Class<A> annotationClass) {
        if (this.annotations.containsKey(annotationClass)) {
            return (A)this.annotations.get(annotationClass);
        }
        return null;
    }

    public String getName() {
        return this.namespace.getName();
    }

    public Package getParentPackage() {
        return null;
    }

    private static Map<Class<? extends Annotation>, Annotation> buildAnnotations(final NamespaceConfig namespace) {
        HashMap<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
        annotations.put((Class<? extends Annotation>)ReadPermission.class, (Annotation)new ReadPermission(){

            public Class<? extends Annotation> annotationType() {
                return ReadPermission.class;
            }

            public String expression() {
                return namespace.getReadAccess();
            }
        });
        annotations.put((Class<? extends Annotation>)Include.class, (Annotation)new Include(){

            public Class<? extends Annotation> annotationType() {
                return Include.class;
            }

            public boolean rootLevel() {
                return true;
            }

            public String description() {
                return namespace.getDescription();
            }

            public String friendlyName() {
                return namespace.getFriendlyName();
            }

            public String name() {
                return namespace.getName();
            }
        });
        annotations.put((Class<? extends Annotation>)ApiVersion.class, (Annotation)new ApiVersion(){

            public String version() {
                return namespace.getApiVersion();
            }

            public Class<? extends Annotation> annotationType() {
                return ApiVersion.class;
            }
        });
        return annotations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NamespacePackage)) {
            return false;
        }
        NamespacePackage other = (NamespacePackage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NamespaceConfig this$namespace = this.namespace;
        NamespaceConfig other$namespace = other.namespace;
        return !(this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NamespacePackage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NamespaceConfig $namespace = this.namespace;
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        return result;
    }
}

